# A11y & i18n Checklist

This checklist helps keep the customer- and admin-facing views accessible and translation-ready. It captures the roles we use, live region strategy, focus management, and i18n conventions. Use it during code reviews and pre-release QA.

## Roles and landmarks

- Document structure
  - [ ] `<main id="main-content">` present on all pages and unique
  - [ ] Skip link present and visible on focus (`href="#main-content"`)
  - [ ] Navigation (`<nav>`) has `aria-label` in specific contexts (e.g., "Mobile actions")
  - [ ] Footer is marked up with `<footer>`

- Components
  - [ ] Toasts and banners:
    - Non-critical messages use `role="status"` (polite)
    - Errors/alerts use `role="alert"` (assertive)
  - [ ] Tabs and filters: tabs use aria-selected, aria-controls, and roving tabindex
  - [ ] Dialogs/menus: proper roles with focus trap and ESC to close
  - [ ] Icons used as buttons include `aria-label` or visible text

## Live regions and announcements

- [ ] Online/offline banner: `aria-live="polite"`, hidden when online
- [ ] KPI changes: hidden SR element announces changes (polite)
- [ ] Order status widget: announces status changes, stops on terminal states
- [ ] Resume order hint: `aria-live="polite"`, auto-dismiss timer does not yank focus
- [ ] Error toasts use `role="alert"` to announce immediately

## Focus management

- Page-level
  - [ ] Skip link takes focus to `#main-content`
  - [ ] Page transitions preserve focus or move it sensibly
  - [ ] After closing overlays, focus returns to the invoking control

- Widgets
  - [ ] Install prompt card:
    - [ ] Close and Dismiss buttons keyboard-operable
    - [ ] Not shown in standalone mode
  - [ ] iOS Add-to-Home-Screen tip:
    - [ ] Close button exists and is keyboard-operable
  - [ ] Mobile sticky bar: focus states visible; ring utilities present

## Color/contrast and motion

- [ ] All interactive elements meet 3:1 contrast ratio (text 4.5:1)
- [ ] Hover/focus outlines visible in light and dark themes
- [ ] Motion respects `prefers-reduced-motion`: no mandatory motion for understanding

## Forms

- [ ] Inputs linked to labels; groups use fieldset/legend as needed
- [ ] Error messages programmatically linked (aria-describedby)
- [ ] Submit buttons disabled during async to avoid double submits

## Internationalization

- Conventions
  - [ ] All user-facing strings wrapped with `__()`
  - [ ] Use JSON translations in `resources/lang/<locale>.json`
  - [ ] Keep sentence case and avoid hard-coded punctuation when fragments are concatenated
  - [ ] Dates, currency, numbers formatted via helpers and localization where possible

- Coverage (initial)
  - [x] Offline banner
  - [x] PWA install card
  - [x] iOS Add-to-Home-Screen tip
  - [x] Resume order hint toast
  - [ ] Dashboard section headings and CTAs (review): ensure all are using `__()`
  - [ ] Orders tabs and search placeholders
  - [ ] Footer and navigation labels (already mostly translatable)

## Testing checklist

- Screen reader smoke test (Narrator/VoiceOver/NVDA)
  - [ ] Navigate header → main → footer using landmarks
  - [ ] Toggle offline/online: banner announces state
  - [ ] Place order and watch status updates: announcements are clear

- Keyboard-only
  - [ ] Tab through nav, cards, and toasts; all focusable; ESC closes overlays
  - [ ] Install card and iOS tip are dismissible without a mouse

- Localization
  - [ ] Switch locale to a test language and scan for hard-coded strings
  - [ ] Verify date, currency, and number formats

## Notes and follow-ups

- Consider adding a centralized `announce()` helper to queue polite messages.
- Add e2e checks for ARIA attributes on critical components.
- Provide alternative text for decorative images via `alt=""`.
