# Inventory & Sales System Roadmap

Author: (auto-generated)  
Last Updated: 2025-10-06

> Scope decisions: BOM/Recipes (ingredient-level) and Allocation/Reservation layers are deferred for later phases. Phase 1 will focus on hardening the existing stock decrement into a service-driven, auditable ledger.

---
## Legend
- [ ] Not Started
- [~] In Progress
- [x] Complete
- (D) Deferred (explicitly postponed)
- (⚑) Milestone / gating task

---
## Phase 0 – Baseline Audit & Preparation
Goal: Understand current state, ensure safe migration path.

Tasks:
- [x] Inventory schema audit (confirm `inventory_movements` fields & indexes)
- [x] Identify all direct `dish->stock` mutations (checkout, admin adjustments, seeders)
- [ ] Determine volume expectations (anticipated daily orders / growth)
- [x] Decide naming conventions for movement reasons (canonical list)
- [ ] Draft failure/rollback scenarios (oversell, cancellation, refund)
- [ ] Create developer handbook section referencing this file

Deliverables:
- [x] Approved canonical movement reasons list
- [x] Risk assessment doc (oversell race, negative stock prevention) — see docs/inventory-risk-assessment.md

---
## Phase 1 – Service Abstraction & Ledger Hardening (Current Focus ⚑)
Goal: Replace ad hoc decrements with a single InventoryService and structured reasons.

Tasks:
- [x] Create `app/Services/Inventory/InventoryService.php`
- [x] Add movement reason validation (enum or config list)
- [x] Refactor checkout decrement to `InventoryService::recordSale()`
- [x] Refactor admin manual adjust to `InventoryService::adjust()`
- [x] Add DB transaction & pessimistic locking (FOR UPDATE) on affected dish row
- [x] Enforce non-negative stock rule in service layer
- [x] Unit tests: sale success, insufficient stock, concurrent decrement scenario
- [x] Feature test: checkout flow with movement recorded
- [ ] Document service usage examples
- [x] Add simple availability method (on_hand == dish.stock for now)
- [x] Update admin dishes list to show On Hand & last movement timestamp (optional)

Deliverables:
- [x] InventoryService contract stable
- [x] All stock mutations centralized
- [x] Test suite green (new inventory tests)
- [x] Developer docs added (see docs/inventory-service.md)

Deferred (tag for reference; not implemented now):
- (D) Allocation logic
- (D) BOM expansion

---
## Phase 2 – Allocation / Reservation Layer (Deferred)
Goal: Introduce allocation movements to separate reserved vs available stock.

Tasks (Deferred):
- (D) Add `allocate(order, dish, qty)` creating reason=allocation movement
- (D) Add `fulfill(order)` converting allocations to final sale movements
- (D) Add `deallocate(order)` on cancel/refund
- (D) Modify availability formula (available = on_hand - allocated)
- (D) Tests: allocation race, cancellation release

Milestone Criteria to Start:
- Phase 1 stable for N days
- Evidence of oversell risk or need for pre-fulfillment capacity planning

---
## Phase 3 – BOM / Recipes (Deferred)
Goal: Ingredient-level consumption & COGS accuracy.

Tasks (Deferred):
- (D) Migrations: ingredients, recipes, recipe_items
- (D) Link dishes to recipe (boolean flag: uses_recipe)
- (D) Ingredient cost tracking (cost_per_unit + unit)
- (D) Expand sale fulfillment into ingredient consumption movements
- (D) Store unit_cost snapshot in movement meta
- (D) COGS calculations & variance report
- (D) Tests: recipe expansion correctness, waste percent handling

Prerequisites:
- Stable ledger semantics (Phase 1)
- Decision on units of measure & rounding strategy

---
## Phase 4 – Admin UI Enhancements
Goal: Visibility & manual control improvements.

Tasks:
- [x] Inventory Dashboard (KPIs subset) – On Hand, Low Stock Count, Top Sellers
- [x] Movements Ledger view (filters: date, reason, dish, user, order)
- [x] Export CSV for movements
- [x] Stock Adjust modal (pre-populated reasons select)
- [x] Low stock highlighting (red) using threshold field per dish (optional new column)
- [x] Add pagination & lazy loading performance checks

---
## Phase 5 – Reporting & KPI Layer
Goal: Provide globally standard operational & financial metrics.

Metrics to Implement (Recommended Global Standards):
1. Gross Sales = Sum(order_items.price * qty) before discounts, taxes, service charges
2. Net Sales = Gross Sales - Discounts - Refunds
3. COGS (Cost of Goods Sold) = Sum(ingredient_qty_consumed * unit_cost_snapshot)
4. Gross Margin % = (Net Sales - COGS) / Net Sales * 100
5. Inventory Turnover = COGS / Average Inventory Value (period)
6. Days of Inventory (Runway) = (On Hand * Period Length) / Units Sold in Period
7. Stockout Rate = (# stockout events) / (# demand events) * 100
8. Fill Rate (Order Fill %) = (Orders fully fulfilled first attempt) / (Total Orders)
9. Shrinkage % = (Theoretical On Hand - Actual Count) / Theoretical On Hand * 100
10. Waste % (if tracked) = (Waste Quantity) / (Total Consumed + Waste) * 100
11. Average Order Value (AOV) = Net Sales / Number of Orders
12. Sales Velocity (units/day) = Units Sold over window / days
13. Return Rate (if applicable) = Returned Units / Units Sold
14. Service Level (optional later) = 1 - (Lost Sales / Potential Demand)

Tasks:
- [ ] Define reporting windows (daily, weekly, monthly)
- [ ] Build aggregation queries (materialized or on-demand caching)
- [ ] Add `reporting:rebuild` artisan command (idempotent)
- [ ] Blade widgets / API endpoints for dashboard consumption
- [ ] Tests: formula accuracy with synthetic dataset

---
## Phase 6 – Forecasting & Alerts
Goal: Predict depletion, notify proactively.

Tasks:
- [ ] Nightly job compute 7d & 30d velocity
- [ ] Projected Runway = on_hand / velocity_7d
- [ ] Safety stock & reorder point fields (dish table or inventory_items later)
- [ ] Low stock alert generation (DB row + optional email/slack)
- [ ] Alert dismissal / acknowledgment workflow
- [ ] Tests: edge cases (zero velocity, high volatility)

---
## Phase 7 – Multi-Location (Deferred)
Goal: Distinguish stock by physical/virtual location.

Tasks:
- [x] locations table
- [x] Add location_id to movements + transfer_group field
- [x] Transfer operations (paired movements transfer_out/transfer_in)
- [x] Movements UI: location filter and column; CSV includes location
- [x] Per-location availability view (basic aggregation)
- [x] Tests: transfer pairing and invariants

---
## Phase 8 – Performance & Snapshot Layer
Goal: Scale reporting and queries.

Tasks:
- [x] inventory_stats table (on_hand, allocated, available, updated_at)
- [x] Scheduled reconciliation job (detect drift vs ledger sum)
- [x] inventory_snapshots (daily) for historical KPI charts
- [x] Index tuning & query plan review (initial pass)
- [~] Benchmarks (baseline vs optimized)

---
## Phase 9 – Advanced Enhancements
Goal: Operational excellence and DX improvements.

Candidates:
- [ ] Websocket push for low stock alerts
- [ ] Barcode/QR-based stock adjust endpoint
- [ ] Event-sourced abstraction (optional) – treat movements as canonical events
- [ ] AI-driven reorder suggestions (lead time + velocity)

---
## Canonical Movement Reasons (Initial Set)
Will solidify in Phase 1:
- sale
- adjustment
- allocation (Deferred)
- deallocation (Deferred)
- receipt (future – supplier inbound)
- spoilage (future)
- shrinkage (future)
- transfer_out / transfer_in (Deferred)
- correction (admin data fix)
- return (future)

---
## Formulas Reference
```
Gross Sales = Σ(item_price * qty)
Net Sales = Gross Sales - Discounts - Refunds
COGS = Σ(consumed_qty * unit_cost_snapshot)
Gross Margin % = (Net Sales - COGS) / Net Sales * 100
Inventory Turnover = COGS / Avg Inventory Value
Days of Inventory = (On Hand / Velocity)  (Velocity = Units Sold / Period Days)
Shrinkage % = (Theoretical - Actual) / Theoretical * 100
Waste % = Waste Qty / (Consumed Qty + Waste Qty) * 100
AOV = Net Sales / Number of Orders
Sales Velocity (units/day) = Units Sold in Window / Window Days
Return Rate = Returned Units / Units Sold
```

---
## Risks & Mitigations
| Risk | Mitigation |
|------|------------|
| Oversell race | Pessimistic row lock + central service |
| Negative stock from manual adjust | Validate new_stock >= 0 before commit |
| Movement reason drift | Central enum + validation rule |
| Performance degradation (large ledger) | Add stats & snapshots, indexing |
| Inconsistent COGS after cost changes | Store unit_cost in movement meta |
| BOM complexity early | Deferred until Phase 3 |
| Allocation overhead premature | Deferred until proven need |

---
## Acceptance Criteria (Phase 1)
- All stock changes produce a movement row with valid reason
- No direct `->decrement('stock')` calls outside InventoryService
- Concurrency test shows second conflicting checkout fails gracefully
- Documentation updated (this file + short README section)

---
## Open Questions / To Decide
- Standard rounding & precision for cost (default: DECIMAL(10,2))
- Timezone normalization for reporting (UTC vs local)
- Handling of partial refunds (reverse sale vs separate return movement)

---
## Change Log
| Date | Change |
|------|--------|
| 2025-10-06 | Initial roadmap created (Phase 1 focus, allocations & BOM deferred) |
| 2025-10-12 | Phase 1 implementation landed (service, locking, tests, admin UI). Phase 4 essentials complete. Checklist updated. |
| 2025-10-17 | Phase 7 completed with per-location availability (standard + pivot views, CSV, totals). Phase 8 kicked off: stats/snapshots tables, scheduled jobs, and performance indexing added. |

---
## Next Immediate Actions (Proposed)
1. Approve or edit canonical movement reasons.
2. Approve Phase 1 task list.
3. Implement InventoryService + refactor checkout & admin adjust.

(Reply with any edits; once confirmed, implementation begins.)
