# Laravel Setup (Windows + XAMPP)

Follow these steps to add Laravel alongside your existing project without overwriting files.

## Prerequisites
- PHP 8.1+ on PATH (XAMPP PHP works). If not on PATH, use full path to php.exe
- Composer on PATH
- MySQL running (XAMPP) and database `bonny_delight` created (db.sql already creates it)

## 1) Create Laravel App
Open PowerShell in `c:\xampp\htdocs\bonny_delight` and run:

```
composer create-project laravel/laravel bonny_app
```

> If Composer is not on PATH, install it from getcomposer.org or run via the Composer PHAR.

## 2) Configure .env
Edit `bonny_app/.env`:

```
APP_NAME=BonnyDelight
APP_URL=http://localhost:9090/bonny_delight/bonny_app/public
DB_DATABASE=bonny_delight
DB_USERNAME=root
DB_PASSWORD=
```

Ensure the DB exists (db.sql will create it) and MySQL user/pass match your XAMPP setup.

## 3) Migrations & Seeders
- Copy files from `laravel-migrations/*.stub` into `bonny_app/database/migrations/` and rename them with a timestamp prefix.
- Convert seed inserts from `db.sql` into Laravel seeders (e.g., `DatabaseSeeder`).

Run migrations:
```
cd bonny_app
php artisan migrate
```

## 4) Auth & RBAC
```
composer require laravel/breeze --dev
php artisan breeze:install
npm install && npm run build
composer require spatie/laravel-permission
php artisan vendor:publish --provider="Spatie\\Permission\\PermissionServiceProvider"
php artisan migrate
```

## 5) Useful Packages
```
composer require guzzlehttp/guzzle paystack/paystack-php twilio/sdk spatie/laravel-permission
```

Configure keys in `.env` (PAYSTACK_SECRET, TWILIO_SID, etc.).

## 6) Serve Locally
Option A (artisan):
```
php artisan serve
```
Visit http://127.0.0.1:8000

Option B (XAMPP Apache): point VirtualHost/alias to `bonny_app/public`.
Access URL (XAMPP on port 9090): http://localhost:9090/bonny_delight/bonny_app/public

## 7) Bring Over UI/Assets
- Move your `assets/` into `bonny_app/public/assets`
- Create Blade layout and include your existing header/footer as partials

## 8) Next Steps
- Implement models, controllers, routes for menu, cart, checkout
- Add queue driver (database initially) for email/SMS
- Add broadcasting (Pusher or Laravel WebSockets) for live order status
