# Performance & Skeletons Plan

This document outlines targeted steps to keep the dashboard and public pages fast and responsive, with clear loading states and minimal blocking JS.

## Goals

- Provide lightweight skeletons for key sections (KPI tiles, recent orders, favorites)
- Defer non-critical JS and hydrate components only when visible
- Minimize network waterfalls and keep asset paths base-safe

## Immediate actions

- KPI tiles
  - [ ] Keep existing skeleton cards; ensure Lucide icon hydration is deferred until after content paint
  - [ ] Cache `/api/me/kpis` for 30s (already implemented) and guard on failure

- Recent orders
  - [ ] Add a 2–3 row skeleton while data loads on first paint (if SSR data may be unavailable)
  - [ ] Paginate and lazy-load more rows on scroll

- Favorites grid
  - [ ] Use `<x-responsive-image>` with proper `sizes`; ensure placeholder color matches theme
  - [ ] Lazy-load offscreen images with `loading="lazy"` and `decoding="async"`

- Orders status polling
  - [ ] Pause polling when `document.hidden` is true
  - [ ] Backoff on repeated network errors

## JS and hydration

- [ ] Ensure Lucide createIcons runs after load; skip if no icons are present
- [ ] Wrap observers for below-the-fold sections (IntersectionObserver) and hydrate when visible
- [ ] Use Alpine component guards to avoid running code until element is in DOM

## Network and bundling

- [ ] Audit Vite bundle for largest modules; split vendor and route-specific chunks
- [ ] Preload critical CSS; ensure fonts use `display=swap`
- [ ] Keep PWA caching conservative to avoid stale critical assets

## Monitoring

- [ ] Add basic `performance.mark` points around KPI load and orders polling
- [ ] Manually test under Fast 3G throttling

## Follow-ups

- Consider skeleton components for cart/checkout with minimal shimmer
- Consider a loading overlay that respects reduced motion and doesn’t trap focus
