# Paystack Integration (Test Mode)

## Configure

1. Set keys in `.env`:

```
PAYSTACK_SECRET=sk_test_xxx
PAYSTACK_PUBLIC_KEY=pk_test_xxx
```

2. Clear cache:

```
php artisan optimize:clear
```

3. Ensure webhook route is accessible:
- URL: `https://your-domain/paystack/webhook` (or `http://127.0.0.1:8010/paystack/webhook` in dev)
- Configure on Paystack Dashboard (Test Mode).

## Flow
- Choose "Pay with Paystack" at checkout.
- We initialize transaction and redirect to Paystack.
- Callback verifies payment and updates the order; webhook also handles success idempotently.

## Test Cards
- PIN + OTP: 5060 6666 6666 6666 666, Exp: any future, CVV: 123, PIN: 1234, OTP: 123456
- PIN only: 5078 5078 5078 5078 12, Exp: any future, CVV: 081, PIN: 1111
- No validation (reusable): 4084 0840 8408 4081, Exp: any future, CVV: 408
- Declined: 4084 0800 0000 5408 (CVV 001)

Refer: https://paystack.com/docs/payments/test-payments/
