## Responsive Image Component

Component: `<x-responsive-image type="dish" base="jollof" alt="Jollof Rice" class="rounded-md" />`

Relies on the generated manifest at `public/assets/image-manifest.json` created by `node scripts/generate-variants.js`.

### Parameters
* type: `dish` or `slider` (selects the manifest list)
* base: Base filename (without extension or `-WIDTH` suffix) used when generating variants.
* alt: Accessible alt text (falls back to capitalised base name)
* class: Extra CSS classes for wrapping `<picture>` / `<img>`
* sizes: Custom sizes attribute; defaults differ for slider vs dish.
* loading: `lazy` (default) or `eager`
* fetchpriority: Optionally `high` for above-the-fold hero media
* fallback: Path (relative to public/) to a static image if the manifest entry does not exist.

### Manifest Lookup
The manifest entries look like:
```
{
  "type": "dish",
  "base": "jollof",
  "variants": [ { "width": 200, "webp": "assets/dishes/jollof-200.webp", ... } ],
  "thumb": "assets/dishes/jollof-thumb-200.jpg",
  "lqip": "assets/dishes/jollof-lqip.jpg"
}
```

### Fallback Behaviour
If the manifest (or specific entry) is missing the component renders either the provided `fallback` image or nothing, allowing progressive rollout.

### LQIP / Fade-In
The component applies a tiny inlined script once per page that:
* Sets a blurred LQIP as a background while the full image loads
* Fades the image in by removing `opacity-0` after load

### Development Notes
The manifest is cached in-memory for 30 seconds by `App\Support\ImageManifest`. Adjust `ttlSeconds` if needed.

### Roadmap (Next Steps)
* Hook variant generation automatically on image upload (job / queue)
* Store canonical base name in `dishes.image_base` to decouple from raw upload filename
* Blade directive for even more concise syntax
* Purge unused variant files via an artisan command
