<p align="center"><a href="https://laravel.com" target="_blank"><img src="https://raw.githubusercontent.com/laravel/art/master/logo-lockup/5%20SVG/2%20CMYK/1%20Full%20Color/laravel-logolockup-cmyk-red.svg" width="400" alt="Laravel Logo"></a></p>

<p align="center">
<a href="https://github.com/laravel/framework/actions"><img src="https://github.com/laravel/framework/workflows/tests/badge.svg" alt="Build Status"></a>
<a href="https://packagist.org/packages/laravel/framework"><img src="https://img.shields.io/packagist/dt/laravel/framework" alt="Total Downloads"></a>
<a href="https://packagist.org/packages/laravel/framework"><img src="https://img.shields.io/packagist/v/laravel/framework" alt="Latest Stable Version"></a>
<a href="https://packagist.org/packages/laravel/framework"><img src="https://img.shields.io/packagist/l/laravel/framework" alt="License"></a>
</p>

## About Laravel

Laravel is a web application framework with expressive, elegant syntax. We believe development must be an enjoyable and creative experience to be truly fulfilling. Laravel takes the pain out of development by easing common tasks used in many web projects, such as:

- [Simple, fast routing engine](https://laravel.com/docs/routing).
- [Powerful dependency injection container](https://laravel.com/docs/container).
- Multiple back-ends for [session](https://laravel.com/docs/session) and [cache](https://laravel.com/docs/cache) storage.
- Expressive, intuitive [database ORM](https://laravel.com/docs/eloquent).
- Database agnostic [schema migrations](https://laravel.com/docs/migrations).
- [Robust background job processing](https://laravel.com/docs/queues).
- [Real-time event broadcasting](https://laravel.com/docs/broadcasting).

Laravel is accessible, powerful, and provides tools required for large, robust applications.

---

## Bonny Delight Application (Project Notes)

This repository has been flattened from an earlier structure where the Laravel app lived in a `bonny_app/` subdirectory alongside a legacy PHP implementation. The legacy code (stand‑alone PHP pages, custom includes, and raw SQL file) has been archived under `archive/legacy-php/` for reference and can be deleted later.

### Key Directories
- `app/`, `bootstrap/`, `config/`, `routes/`, `resources/`, `public/` — standard Laravel layout (now at repo root)
- `public/assets/` — images, responsive variants, icons, CSS/JS build outputs
- `archive/legacy-php/` — deprecated legacy site (redirect stubs, old assets, db.sql)
- `scripts/` — maintenance and DB scripts; `scripts/build/` contains image/icon generation utilities

### Environment
Copy `.env.example` to `.env` and set secrets:
```
cp .env.example .env  # (Windows PowerShell: Copy-Item .env.example .env)
php artisan key:generate
```
Ensure database `bonny_delight` exists and run migrations + seeders:
```
php artisan migrate --seed
```

### Serving Locally (Root Mode)
The application now runs at the web root (no subdirectory path needed).

Option A (Artisan dev server):
```
php artisan serve --host=127.0.0.1 --port=9090
```
Visit: http://127.0.0.1:9090

Option B (Apache / XAMPP): Point a VirtualHost `DocumentRoot` directly to:
```
C:/xampp/htdocs/bonny_delight/public
```
Then set in `.env`:
```
APP_URL=http://localhost:9090
```
If you previously served the app from a subdirectory (e.g. `/bonny_delight`), remove rewrite rules and cached configs:
```
php artisan config:clear
php artisan route:clear
```

### Build Frontend Assets
If using Vite & Tailwind (optional for critical pages which have fallbacks):
```
npm install
npm run build    # or: npm run dev
```

### Design System
Tokens and component styles live in `resources/css/app.css`. A documentation scaffold has been added in `docs/DESIGN_SYSTEM.md`.

### Cleanup Summary
- Removed legacy root PHP entrypoints; archived under `archive/legacy-php/`.
- Flattened Laravel app from `bonny_app/` to root.
- Converted legacy DB seed data into proper Laravel seeders (`CategorySeeder`, `DishSeeder`).
- Standardized deployment to root (no subdirectory path). `APP_URL` now defaults to `http://localhost:9090`.

### Testing Notes
- The PHPUnit configuration sets `APP_URL` to `http://localhost` to ensure deterministic route matching in the in-memory test kernel.
- If you change `APP_URL` for local browsing, you do NOT need to mirror it in tests unless you assert absolute URLs.

---

## Learning Laravel

Laravel has the most extensive and thorough [documentation](https://laravel.com/docs) and video tutorial library of all modern web application frameworks, making it a breeze to get started with the framework.

You may also try the [Laravel Bootcamp](https://bootcamp.laravel.com), where you will be guided through building a modern Laravel application from scratch.

If you don't feel like reading, [Laracasts](https://laracasts.com) can help. Laracasts contains thousands of video tutorials on a range of topics including Laravel, modern PHP, unit testing, and JavaScript. Boost your skills by digging into our comprehensive video library.

## Laravel Sponsors

We would like to extend our thanks to the following sponsors for funding Laravel development. If you are interested in becoming a sponsor, please visit the [Laravel Partners program](https://partners.laravel.com).

### Premium Partners

- **[Vehikl](https://vehikl.com)**
- **[Tighten Co.](https://tighten.co)**
- **[Kirschbaum Development Group](https://kirschbaumdevelopment.com)**
- **[64 Robots](https://64robots.com)**
- **[Curotec](https://www.curotec.com/services/technologies/laravel)**
- **[DevSquad](https://devsquad.com/hire-laravel-developers)**
- **[Redberry](https://redberry.international/laravel-development)**
- **[Active Logic](https://activelogic.com)**

## Contributing

Thank you for considering contributing to the Laravel framework! The contribution guide can be found in the [Laravel documentation](https://laravel.com/docs/contributions).

## Code of Conduct

In order to ensure that the Laravel community is welcoming to all, please review and abide by the [Code of Conduct](https://laravel.com/docs/contributions#code-of-conduct).

## Security Vulnerabilities

If you discover a security vulnerability within Laravel, please send an e-mail to Taylor Otwell via [taylor@laravel.com](mailto:taylor@laravel.com). All security vulnerabilities will be promptly addressed.

## License

The Laravel framework is open-sourced software licensed under the [MIT license](https://opensource.org/licenses/MIT).
