Local Development Guide
=======================

This document summarizes local workflows after decommissioning the legacy PHP site.

## Quick Start

1. Ensure MySQL is running (XAMPP control panel).
2. Copy `.env.example` to `.env` if missing and set credentials.
3. Install PHP deps: `composer install`
4. Install Node deps (optional for assets): `npm install`
5. (Option A) One-shot bootstrap (drops & recreates schema + seeds + shows credentials):
  `php artisan local:bootstrap --fresh`

  (Option B) Manual steps:
  `php artisan migrate --force && php artisan db:seed --force`

6. Start dev server:
  `php artisan serve --host=127.0.0.1 --port=8010`

APP_URL should be `http://localhost:8010` locally.

## Health Check
Local-only endpoint:
  GET /healthz
Returns JSON with DB status and latency. Non-200 indicates internal issue.

## Debug DB Endpoint
  GET /_debug/db
Lists current database and tables (local environment only).

## Backups
Use the PowerShell script: `scripts/windows/backup_db.ps1`
Creates compressed `backups/bonny_delight-<timestamp>.sql.zip` and prunes >14 days.

Example:
```
powershell -ExecutionPolicy Bypass -File .\scripts\windows\backup_db.ps1
```

Schedule via Windows Task Scheduler daily at off-peak hours.

## Queues & Scheduling (Future)
To enable background jobs:
  - Set QUEUE_CONNECTION=database
  - Run: `php artisan queue:work --tries=3`
For scheduled tasks: create tasks in `app/Console/Kernel.php` and a system scheduler invoking:
  `php artisan schedule:run` every minute.

## Testing
Install test dependencies:
  `composer require --dev mockery/mockery`
Run tests:
  `php artisan test`

Smoke test specific feature:
  `php artisan test --filter=Checkout` (example)

Environment isolation: automated tests use `.env.testing` (sqlite :memory:) and do not touch your local MySQL.

Reset local DB & reseed quickly:
  `php artisan local:bootstrap --fresh`

Composer shortcut (includes --force for non-prod safety bypass):
  `composer run local:bootstrap`

## Security Checklist (Local → Prod)
In production set:
  APP_ENV=production
  APP_DEBUG=false
  LOG_LEVEL=info
Use HTTPS and configure security headers (middleware or server config).

## Decommission Notes
Legacy root PHP files now only redirect. See `DECOMMISSION_LEGACY.md` (project root) for migration summary.

## Support Scripts
`scripts/windows/backup_db.ps1` – DB backups
Add more scripts under `scripts/` as the project grows.

---
Revision: Initial local ops guide (auto-generated).

## Seeded Test Accounts (local only)
All seeded users use the `@bonnydelight.ng` domain. Passwords (change in production):

| Email | Role(s) | Password |
|-------|---------|----------|
| admin@bonnydelight.ng | Super Admin | ChangeMe123! |
| manager@bonnydelight.ng | Manager | TestPass123! |
| kitchen@bonnydelight.ng | Kitchen | TestPass123! |
| cashier@bonnydelight.ng | Cashier | TestPass123! |
| editor@bonnydelight.ng | Content Editor | TestPass123! |
| rider@bonnydelight.ng | Rider | TestPass123! |
| customer@bonnydelight.ng | Customer | TestPass123! |
| admin.tester@bonnydelight.ng | Manager | AdminTest123! |
| user.tester@bonnydelight.ng | Customer | UserTest123! |

Run `php artisan local:bootstrap` anytime to re-display these after rebuilding.

## Image Storage (Centralized)
Originals (after consolidation) live on the `public` disk (physical path: `storage/app/public`).

Paths you should use:
 - Dish originals (uploaded or consolidated): `storage/app/public/dishes/` (hash-named). Served via `/storage/dishes/<hash>.jpg`.
 - Slider (hero) originals: `storage/app/public/sliders/` (you can add your JPG/PNG hero images here). After placing images run:
   `php artisan images:variants --type=sliders`

Generated responsive variants are written under:
 - `public/assets/dishes/` (resized dish images)
 - `public/assets/slider/` (resized slider images)

Manifest file consumed by Blade components:
 - `public/assets/image-manifest.json`

If `storage/app/public/sliders` does not exist the variants command will create it and prompt you to add images.
