Apache local serving options
============================

This doc shows the easiest ways to serve the app on Windows (XAMPP) without fighting the built‑in PHP server. Pick one based on how simple you want it to be.

Quickest way (no vhost)
-----------------------
Use the Apache that ships with XAMPP and hit the project directly via its `public` folder.

1) Start Apache from XAMPP Control Panel.
2) Visit:

   http://localhost/bonny_delight/public

Tips:
- If routes return 404, ensure Apache’s `mod_rewrite` is enabled and that `public/.htaccess` exists (it does in this repo).
- If redirects or asset URLs try to jump to another host/port, set `APP_URL=http://localhost` in `.env` and clear config cache.

PowerShell (optional) to adjust `.env` and clear caches:

```powershell
# From project root
(Get-Content .env) -replace '^APP_URL=.*', 'APP_URL=http://localhost' | Set-Content .env
C:\xampp\php\php.exe artisan optimize:clear
```

One‑liner PHP server (fallback)
-------------------------------
If you prefer a quick dev server and your firewall allows it:

```powershell
# Run in a regular PowerShell window (not the VS Code integrated one), first time allow firewall prompt
cd C:\xampp\htdocs\bonny_delight
C:\xampp\php\php.exe -S 127.0.0.1:8010 -t public public/index.php
```

Then open http://127.0.0.1:8010. If it won’t bind, use Apache methods above.

Production‑like vhost (clean URL)
---------------------------------
This replaces `php artisan serve` with an Apache virtual host pointing directly to `public`.

## 1) Edit XAMPP httpd-vhosts.conf
Typically located at:
  C:/xampp/apache/conf/extra/httpd-vhosts.conf

Append the following (adjust paths if needed):

```
<VirtualHost *:80>
  ServerName bonny.local
  ServerAlias www.bonny.local
  DocumentRoot "C:/xampp/htdocs/bonny_delight/public"

  <Directory "C:/xampp/htdocs/bonny_delight/public">
    AllowOverride All
    Options Indexes FollowSymLinks
    Require all granted
  </Directory>

  ErrorLog "logs/bonny-error.log"
  CustomLog "logs/bonny-access.log" combined
</VirtualHost>
```

Ensure the line in `httpd.conf` that loads vhosts is enabled (not commented):
  `Include conf/extra/httpd-vhosts.conf`

## 2) Update hosts file
Add to: C:\Windows\System32\drivers\etc\hosts

```
127.0.0.1   bonny.local
```

## 3) Restart Apache
Use XAMPP Control Panel → Stop/Start Apache.

## 4) Update `.env`
Set:
```
APP_URL=http://bonny.local
```
(Remove `APP_PORT` if set; not needed for a vhost.)

Then clear cache:
```powershell
C:\xampp\php\php.exe artisan optimize:clear
```

## 5) Access the site
Visit http://bonny.local

Optional: Force HTTPS (when using local TLS)
--------------------------------------------
If you enable a local certificate via mkcert or similar:
```
<VirtualHost *:443>
  ServerName bonny.local
  DocumentRoot "C:/xampp/htdocs/bonny_delight/public"
  SSLEngine on
  SSLCertificateFile "C:/certs/bonny.local.pem"
  SSLCertificateKeyFile "C:/certs/bonny.local-key.pem"
  <Directory "C:/xampp/htdocs/bonny_delight/public">
    AllowOverride All
    Options Indexes FollowSymLinks
    Require all granted
  </Directory>
</VirtualHost>
```

Then add an HTTP → HTTPS rewrite (inside the port 80 vhost):
```
RewriteEngine On
RewriteCond %{HTTPS} !=on
RewriteRule ^ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]
```

Legacy redirect cleanup (optional)
----------------------------------
Once the vhost is active you may convert file-based legacy redirects into rewrite rules *if those legacy files are removed*:
```
RewriteCond %{REQUEST_FILENAME} !-f
RewriteRule ^(menu|cart|checkout|login|register|logout|order_history|order_tracking)\.php$ /$1 [L,R=302]
```
Retain 302 temporarily; switch to 301 after verifying all external references.

Verification checklist
----------------------
1. `bonny.local` resolves to 127.0.0.1
2. Visiting the chosen URL loads the Laravel landing page
3. Static assets load
4. Health check: `/healthz` (local env only)
5. No mixed‑content warnings (if using HTTPS)

Troubleshooting
---------------
- Port already in use: Ensure no other vhost conflicts.
- Blank page / directory listing: Confirm `public/.htaccess` and `AllowOverride All`.
- Env not updating: run `artisan optimize:clear`.
- If `php -S` won’t bind, prefer Apache methods above.

Quick smoke test steps
----------------------
- Login: http://bonny.local/login (or http://localhost/bonny_delight/public/login)
  - Email: `superadmin@bonnydelight.ng`
  - Password: `ChangeMe123!`
- Super Admin dashboard: http://bonny.local/super-admin
  - If access denied, run: `php artisan super-admin:setup superadmin@bonnydelight.ng`
- Images: Open Admin → Top Selling Dishes to confirm thumbnails render.
- Checkout: Add an item to cart and open `/checkout`; verify the "Deliver to" dropdown and room validation show as expected.

Helper script
-------------
You can run `scripts/windows/setup-bonny-local.ps1` (as Administrator) to:
- Add the `bonny.local` hosts entry
- Set `APP_URL` in `.env`
- Clear Laravel caches
- Print a ready-to-paste vhost block

—
This doc helps you run locally without relying on `php artisan serve`.
