# Bonny Delight Food Ordering & Admin System — Project TODO

A comprehensive, checkable roadmap. Tick items as they’re completed. Keep scope visible by phases and domains.

Legend: [ ] not started · [~] in progress · [x] done · (AC) acceptance criteria

---

## Phase 0 — Decisions, Setup, and Foundations
- [x] Confirm stack selection → Laravel MVC (Blade, Eloquent, queues, CSRF, auth)
  - [x] Scaffold Laravel app in a subfolder (e.g., `bonny_app`) to keep existing files
  - [x] Configure `.env` for XAMPP (APP_URL :9090; DB: `bonny_delight_laravel`, root/no pass)
  - [x] Create migrations from `db.sql` (use `laravel-migrations/create_core_tables.stub`) — users extended; core tables added
  - [x] Add Breeze (auth scaffolding) and Spatie Permissions (RBAC)
- [ ] Environment & config
  - [~] Create `.env` (app, DB, mail, SMS, Paystack, Google APIs) and `.env.example` (example updated with PAYSTACK + Lagos timezone)
  - [x] Implement config loader (`config.php`) using env values; centralize constants (done; plus BASE_PATH url helper)
  - [~] Set app URL, timezone, locale, currency (₦) (timezone/env wired; URL set in .env; currency pending)
- [ ] Composer & packages
  - [x] Initialize Composer (local composer.phar) and install Laravel
  - [ ] Add: PHPMailer, Twilio SDK (or alternative), Paystack SDK, Guzzle, Workbox CLI (node), PhpSpreadsheet (for CSV/Excel)
- [ ] Git & CI
  - [ ] Initialize Git, sensible `.gitignore` (vendor, node_modules, env)
  - [ ] Set up GitHub Actions: lint, unit tests, basic security scans
- [ ] OPcache & PHP settings
  - [ ] Enable OPcache in php.ini (prod), set memory limits sensibly

(AC) Project installs with `composer install`; app boots locally with configured DB connection.

---

## Phase 1 — Brand, Design System, and UI Kit
- [ ] Assets
  - [x] Use provided Bonny Delight logo across pages (navbar, hero)
  - [ ] Generate favicon + app icons (maskable PNGs 512×512, 192×192, 180×180)
- [ ] Color system (CSS variables)
  - [x] Define: Charcoal #1F2937, Bonny Blue #2563EB, Coral #F97316, Pearl #F8FAFC, Gold #D4AF37 (in `assets/css/style.css`)
  - [ ] Implement light/dark themes via CSS custom properties
- [ ] Typography
  - [ ] Add Playfair Display/Cormorant (headlines), Inter/SF Pro (body) via Google Fonts
- [ ] Icons & motion
  - [ ] Material Symbols Rounded; standardize icon sizes
  - [ ] Add 200–250ms transitions, respects prefers-reduced-motion
- [ ] Components with Bootstrap 5
  - [~] Buttons, cards, navbar, forms in use; no sidebar/toasts yet

(AC) A styleguide page demonstrates tokens, typography, components, and motion.

---

## Phase 2 — Layout & Navigation
- [~] Responsive, mobile-first grid (Bootstrap used across pages)
  - [x] Sticky top bar on public pages (logo left, “Order Now” right)
- [ ] Collapsible sidebar for dashboards (overlay with scrim, icon-only collapsed)
- [ ] 44px minimum tap targets; focus states visible

(AC) Lighthouse/AXE checks pass for nav, focus, and touch targets.

---

## Admin Area — Modern, responsive, accessible UI (Collapsible Sidebar)

Goal: A clean, fast Admin with a collapsible sidebar, keyboard-friendly navigation, consistent components, and responsive layouts. Uses Tailwind + Lucide icons; minimal JS; server-rendered Blade with progressive enhancements.

### A) Information Architecture & Navigation
- [ ] Define Admin IA and route-to-nav map
  - [ ] Sections: Dashboard, Orders, KDS, Categories, Dishes, Modifiers, Promotions, Customers, Reports, Settings, Users/Roles, Audit Log
  - [ ] Specify which roles see which entries (RBAC gating)
- [ ] Active state and breadcrumbs
  - [ ] Breadcrumbs component deriving from route name hierarchy
  - [ ] Highlight current route in sidebar and responsive menu
- [ ] Global search (phase 2)
  - [ ] Command‑palette style search (Ctrl/Cmd+K) for quick nav and entity lookup

(AC) Every Admin page reachable in ≤2 clicks; current location is obvious via highlight and breadcrumbs.

### B) Layout Shell & Components
- [ ] Create dedicated Admin layout (Blade)
  - [ ] File: `resources/views/layouts/admin.blade.php`
  - [ ] Slots: sidebar, topbar, main, toasts
  - [ ] Persist dark/light theme from `x-app-layout`; use Tailwind classes
- [ ] Collapsible Sidebar component
  - [ ] File: `resources/views/components/admin/sidebar.blade.php`
  - [ ] Collapse/expand toggle (desktop: icon-only collapsed; mobile: overlay + scrim)
  - [ ] State persisted to localStorage (`admin:sidebar=collapsed|expanded`)
  - [ ] ARIA: `aria-expanded`, focus trap when open on mobile, Esc to close
  - [ ] Keyboard: Tab order, arrow key nav between items
- [ ] Topbar component
  - [ ] File: `resources/views/components/admin/topbar.blade.php`
  - [ ] Contains: page title slot, search entry, user menu, theme toggle
- [ ] JS enhancers (tiny, framework-free or Alpine)
  - [ ] File: `resources/js/admin-sidebar.js` (open/close, focus trapping, persist state)
  - [ ] Initialize Lucide icons on Turbo/Livewire/alpine navigation events if used
- [ ] Vite entry for admin
  - [ ] `resources/js/admin.js` imports admin-sidebar.js; `@vite(['resources/js/admin.js'])` in admin layout

(AC) Sidebar collapses smoothly, works with keyboard, and looks great on xs–xl breakpoints.

### C) Visual System & Tokens (Tailwind)
- [ ] Tailwind tokens for Admin
  - [ ] Extend `tailwind.config.js` with brand colors, shadows, radii, z-indexes used in Admin
  - [ ] Use `data-theme` or `dark` class for color schemes
- [ ] Iconography with Lucide
  - [ ] Consistent 16/20/24 sizing, color semantics (informational, success, warning, danger)
- [ ] Layout rhythm and density
  - [ ] 8pt spacing scale; 1.25/1.5 line heights; tactile focus states meeting WCAG AA

(AC) Visuals consistent across pages; no ad-hoc sizes; dark mode works end-to-end.

### D) Core Admin UX Patterns
- [ ] Page header + actions bar pattern (title, primary CTA, filters)
- [ ] Data Table component
  - [ ] Blade component: `resources/views/components/admin/table.blade.php`
  - [ ] Server-side pagination, sorting, filtering
  - [ ] Empty, loading, and error states
  - [ ] Row selection, bulk actions (delete/export), and CSV export (server endpoint)
- [ ] Form components
  - [ ] Text, select, checkbox/switch, textarea, number, image upload, date/time
  - [ ] Field help text, inline validation messages
  - [ ] Client-side constraints (pattern, min/max) + server validation
- [ ] Feedback components
  - [ ] Toasts: `resources/views/components/toast.blade.php` + Alpine/JS auto-dismiss
  - [ ] Confirm dialog for destructive actions; Esc to cancel; focus management
- [ ] Loading skeletons
  - [ ] Skeleton rows/cards while lists load or submit

(AC) Lists and forms feel coherent; errors are clear; actions give immediate feedback.

### E) Apply Shell to Existing Admin Pages
- [ ] Switch Admin pages to `layouts/admin.blade.php`
  - [ ] Dashboard
  - [ ] Categories, Dishes
  - [ ] Orders (index/show/update)
  - [ ] Settings
- [ ] Sidebar nav links (with Lucide icons) for the above
- [ ] Move status badges to reusable `x-badge` component

(AC) All current Admin pages adopt the new shell without layout regressions.

### F) Media & Uploads (Dishes)
- [ ] Image upload field with preview
  - [ ] Use `storage` disk, generate safe filenames
  - [ ] Validate type/size; server-side image optimization
- [ ] Responsive images pipeline integration
  - [ ] Dispatch job on upload to produce AVIF/WebP/JPEG variants + LQIP
  - [ ] Use `<x-img>` component on list/detail views

(AC) Upload is smooth, images optimized, and previews consistent with the public site.

### G) Orders UX Enhancements
- [ ] Orders table filters: status, payment method, date range, customer
- [ ] Quick status actions in table rows (dropdown or inline) with optimistic UI
- [ ] Order timeline panel (timestamps + actor + notes); audit trail
- [ ] Print ticket (kitchen/customer) with print stylesheet
- [ ] KDS view (separate screen)
  - [ ] Columns for Received/In Kitchen/Ready; drag to move status; sound alerts for new

(AC) Staff can triage orders rapidly; status changes are quick and auditable.

### H) Settings UX Expansion
- [ ] Grouped tabs: Business, Orders, Delivery, Room Service, Payments, Integrations, PWA
- [ ] Secrets input pattern (show/hide, masked, not re‑rendered on load)
- [ ] Inline validation and success/failure toasts

(AC) Key configs editable safely; secrets never leak in HTML.

### I) RBAC & User Management UI
- [ ] Users list, invite flow, password reset link
- [ ] Role and permission management screens (Spatie integration)
- [ ] Guard sensitive actions with password/2FA re‑auth

(AC) Only authorized roles see and can execute sensitive actions.

### J) Accessibility & Internationalization
- [ ] Keyboard: tab order, skip links, ARIA labels, focus outlines, `prefers-reduced-motion`
- [ ] Screen reader labels for toggles, icons, dialogs
- [ ] Language keys for Admin copy; support en → future locales

(AC) AXE shows no serious violations; keyboard-only use is fully supported.

### K) Performance & Reliability
- [ ] Defer Lucide init; tree-shake unused icons
- [ ] Only load admin.js on admin pages (separate Vite entry)
- [ ] Cache heavy queries; paginate; eager load
- [ ] Guard N+1 in tables (use withCount/with)
- [ ] Handle slow networks: timeouts, retry UX

(AC) Admin loads fast on 3G; p95 under target; no waterfall queries in lists.

### L) Observability & Audit
- [ ] Admin activity log (model + observer + middleware)
  - [ ] Track create/update/delete, settings changes, status updates, log in/out
  - [ ] Store actor, route, IP, UA, payload diff (redact secrets)
- [ ] Admin log view with filters and CSV export

(AC) Every sensitive change is traceable to a user, time, and context.

### M) QA & Documentation
- [ ] Lighthouse/AXE checks ≥ 90 for Accessibility and Best Practices on Admin pages
- [ ] Unit tests for table filters, settings save, RBAC gates; feature tests for flows
- [ ] Admin UX guide (navigation, filters, exports, printing)

(AC) CI runs tests; Admin guide helps onboard new staff quickly.

---

## Phase 3 — Public Pages (Content CMS-backed where applicable)
- [ ] Home/Index
  - [x] Hero: “Refined Dining, Right to Your Room or Doorstep”
  - [ ] Chef’s Specials carousel (grid without carousel)
  - [x] Signature Nigerian dishes grid
  - [x] Room‑service advantages
  - [ ] Events & Private Dining highlights
  - [ ] Catering packages
  - [ ] Delivery coverage map (Google Maps polygon)
  - [ ] Testimonials, Gallery
  - [ ] Newsletter signup
  - [ ] Contact section with PWA install QR badge
- [ ] Static pages (editable from Admin)
  - [~] Events, Terms, Privacy exist as static pages; others pending

(AC) All public pages responsive, content editable in Admin, no broken links.

---

## Phase 4 — Catalog: Categories, Dishes, Modifiers
- [ ] Data model
  - [x] Categories, Dishes (images via path)
  - [ ] Modifier Groups, Modifiers, Dish↔Modifier assignments with price deltas
  - [ ] Dietary labels, spice levels
- [ ] Menu page
  - [x] Category sections and dish listing
  - [x] Dish cards: image, description, price
  - [x] Load menu from DB as JSON endpoint for reuse (PWA caching)

(AC) CRUD from Admin creates items visible on Menu; modifiers show in order flow.

---

## Phase 5 — Cart & Order Flow (Room Service / Delivery / Pickup)
- [ ] Cart
  - [~] Add items and increment quantity; no remove/edit UI; no modifiers; sums basic
  - [x] Persist cart (session)
- [ ] Checkout steps
  - [ ] Select fulfillment: Room (if verified), Delivery, Pickup (basic address only)
  - [ ] Schedule now/later (validate slots)
  - [ ] Delivery address autocomplete (Google Places)
  - [ ] Payment method select: COD, Paystack, Charge to Room (if guest)
  - [x] Tip input; summary with fees/discounts
  - [ ] Review & confirm
- [ ] Orders
  - [x] Create order and order_items; basic discount via guest checkbox

(AC) End-to-end order submission works for COD (happy path) with correct totals.

---

## Phase 6 — Authentication & Verification
- [ ] Auth routes
  - [x] Sign‑up (first_name, last_name, gender, email, phone, password; optional room)
  - [x] Sign‑in (email + password)
  - [ ] Optional OAuth (Google/Apple) — deferred if not needed initially
- [ ] Verification
  - [ ] Email verification with PHPMailer (token, expiration, rate-limit)
  - [ ] Phone verification via SMS OTP (Twilio/alt), rate-limit and lockouts
  - [ ] Store `email_verified`, `phone_verified`
- [ ] Guest verification (hybrid)
  - [ ] PMS/Ez‑Hotel API lookup room+surname
  - [ ] Fallback SMS OTP to reservation phone
  - [ ] Daily secure sync of active guests → `GuestSession` (room, initials, checkout)

(AC) Users must have both verifications to place orders; verified guests can select Charge to Room.

---

## Phase 7 — Delivery & Pricing
- [ ] Distance Matrix integration
  - [ ] Compute driving distance hotel→drop‑off via Google Maps Distance Matrix API
  - [~] Pricing bands UI (selector) present; no API distance logic
  - [ ] Cap fees out of zone and show friendly message
- [ ] Scheduling
  - [ ] Allow future date/time; guests may schedule to room while away
- [ ] Live tracking (optional)
  - [ ] Rider app or dashboard; websockets updates

(AC) Delivery fee calculated server-side; business rules enforced at checkout.

---

## Phase 8 — Discounts, Payments, and Tips
- [ ] Discounts engine (Admin configurable)
  - [ ] Percent off subtotal, free base delivery, time windows, item eligibility
  - [ ] Black‑out dates, per‑room/day caps
- [ ] Payments
  - [x] COD
  - [~] Paystack integration (hosted checkout or inline); store transaction refs; webhook verification (HMAC signature, idempotency) (checkout + callback implemented; webhook verification pending)
  - [ ] Charge to Room for verified guests
- [ ] Tips
  - [ ] Optional tip stored in order metadata; display on receipts

(AC) At least one online payment succeeds; webhooks securely processed and orders updated.

---

## Phase 9 — Order Tracking, KDS, Dispatch, Admin
- [ ] Status flow
  - [x] Received → In Kitchen → Ready → Out for Delivery → Delivered (manual via Admin)
  - [ ] Long polling or websockets (Ratchet/Pusher) for live updates
  - [ ] Order status logs with timestamps and actor
- [ ] KDS (Kitchen Display System)
  - [ ] Station views (Grill, Salad, Pastry, Bar)
  - [ ] Bump/recall, color timers, sound alerts
- [ ] Dispatch
  - [ ] Manage riders, assign orders, map routes, location updates, OTP on delivery
- [ ] Admin RBAC
  - [ ] Roles: Super Admin, Manager, Kitchen, Cashier, Rider, Support, Content Editor
  - [ ] Middleware-based permissions
- [ ] Admin dashboards & CRUD
  - [~] Metrics: counts by status implemented on dashboard (no charts)
  - [x] Menus: CRUD categories, dishes (image path field, no uploads)
  - [ ] Modifiers & combos management
  - [~] Orders management (list + update status)
  - [ ] Reports (sales mix, bands, SLAs, refunds) CSV export via PhpSpreadsheet
  - [ ] Settings: tax/service/packaging, payment keys, verification APIs, content blocks, PWA metadata, email/SMS providers

(AC) Admin can manage menu and orders end-to-end with role-restricted access.

---

## Phase 10 — PWA & Offline
- [x] `manifest.json` with icons, theme, scope, start URL
- [~] Service worker (Workbox) to cache menu JSON, assets, and HTML for offline browse (basic cache-first SW added)
- [ ] Offline COD order queue; sync when back online
- [ ] PWA install prompts; QR badge on Contact page

(AC) App installable on iOS/Android; offline browsing works; queued orders sync reliably.

---

## Phase 11 — Security, Privacy, and Compliance
- [x] Passwords hashed with `password_hash()`; auth with `password_verify()` (legacy MD5 supported for seed)
- [~] Prepared statements (PDO) for user input; some direct queries remain
- [ ] CSRF protection on forms; same‑site cookies; session hardening
- [ ] Rate-limit OTP/email verification; account lockouts; reCAPTCHA on high‑risk forms
- [ ] Verify Paystack webhooks (signature + idempotency keys)
- [ ] Audit logs of admin actions
- [ ] GDPR-style cookie/analytics consent; privacy policy
- [ ] WCAG 2.1 AA: keyboard navigation, alt text, contrast, reduced motion

(AC) Basic pen-test checklist passes; no high-severity findings.

---

## Phase 12 — SEO & Analytics
- [ ] Structured data (schema.org: Restaurant, Menu, Product, AggregateRating)
- [ ] sitemap.xml, robots.txt, canonical tags
- [ ] Open Graph/Twitter meta tags
- [ ] Google Analytics + Tag Manager integration
- [ ] Register/verify Google Business Profile, link website

(AC) Pages indexed; rich results detected in Search Console.

---

## Phase 13 — Performance, Caching, and Observability
- [ ] Enable OPcache; HTTP caching headers for static assets; gzip/brotli
- [ ] Redis for sessions and cache (if available)
- [ ] Query optimization; indexes; pagination for large lists
- [ ] CDN for static assets (images, CSS/JS)
- [ ] Logging/monitoring: error logs, uptime checks, Slack/Email alerts

(AC) Core Web Vitals good; p95 response time meets target under load.

---

## Phase 14 — Database Schema (MySQL 8)
- [ ] Core tables
  - [x] users (email, phone, password_hash; plus first_name, last_name, gender)
  - [ ] roles, user_roles (RBAC)
  - [x] categories, dishes (images via path)
  - [ ] modifiers, modifier_groups, dish_modifier
  - [ ] carts, cart_items
  - [x] orders, order_items
  - [ ] payments, refunds
  - [ ] discounts, discount_rules, order_discounts
  - [ ] deliveries (address, geo, fees, distance_km, schedule)
  - [ ] riders, rider_locations
  - [ ] guest_sessions, verifications (email/phone)
  - [ ] settings, audit_logs, content_blocks
- [ ] Seeders for sample data; ERD diagram

(AC) `db.sql` builds schema cleanly; seeds load; foreign keys validated.

---

## Phase 15 — Frontend Enhancements (Progressive)
- [ ] Introduce Vue.js or Alpine.js for reactive widgets (cart, KDS, tracking)
- [ ] Keep Bootstrap for styling; modular JS; ES6 build (Vite/ESBuild) if needed

(AC) Cart updates and KDS screens update without page reloads.

---

## Phase 16 — QA, Release, and Documentation
- [ ] Unit/integration tests for pricing, discounts, payments, verification
- [ ] E2E happy-path flows (guest room charge, delivery, pickup, paystack)
- [ ] Content review for voice (formal hospitality—warm, concise, premium)
- [ ] Admin training guide and runbooks (refunds, discounts, outages)
- [ ] CHANGELOG and versioning

(AC) All test suites green in CI; go-live checklist signed off.

---

## Cross-Cutting Checklists
- [ ] Accessibility pass on every new page (keyboard, contrast, labels)
- [ ] Mobile-first review at breakpoints (xs/sm/md/lg/xl)
- [ ] Error states and empty states designed and implemented
- [ ] Logging for all critical actions (order create, payment, status change)
- [ ] Graceful failures: retries/backoff for API calls (Guzzle)

---

## Migrations From Current Files (if staying on vanilla PHP)
- [x] Convert current pages to use shared header/footer includes consistently
- [ ] Centralize routing (avoid many entry-point PHP files)
 - [x] Replace direct SQL with PDO prepared statements
 - [ ] Move business logic out of templates into functions/classes
- [ ] Add CSRF tokens to forms in `login.php`, `register.php`, `checkout.php`

---

## Admin CMS Content Hooks
- [ ] Editable: hero text, specials, events blocks, gallery, testimonials
- [ ] Terms & Privacy content store; versioning

---

## Deliverables Inventory (for traceability)
- [ ] Design tokens (CSS variables), styleguide page
- [ ] Icons and favicons set (512, 192, 180, favicon.ico, maskable)
- [ ] manifest.json and service-worker.js
- [ ] API endpoints: menu JSON, cart, checkout, orders, tracking, admin CRUD
- [ ] Websocket server config (or Pusher keys) + client wiring
- [ ] Docs: README, ENV template, Admin Guide, Runbooks

---

## Notes
- Prioritize MVP: Public Menu, Cart, COD checkout, Email/Phone verification, Basic Admin (menu CRUD), Simple order status without websockets. Add Paystack, KDS, websockets in Iteration 2.
- Keep performance in mind from day one: cache menu JSON, lazy‑load images, compress assets.

---

Temporary change for local testing
- [x] Relax email verification requirement so accounts can log in without verifying email.
  - Changed `app/Models/User.php` to remove `implements MustVerifyEmail` and the related import.
  - Removed the `verified` middleware from the `/dashboard` route in `routes/web.php`.
  - Keep `email_verified_at` column intact for future use.
- [ ] Re-enable email verification before production.
  - Re-add `implements MustVerifyEmail` to `User` and `use Illuminate\Contracts\Auth\MustVerifyEmail;`
  - Restore `->middleware(['auth','verified'])` where needed (dashboard, protected areas)
  - Enable mail transport in `.env` and wire notification templates
  - Optionally add resend verification notice and throttling
