# Upgrading PHP on Windows for Laravel 12+ (XAMPP Compatible)

This guide walks you through installing PHP 8.3 side-by-side with XAMPP, configuring extensions, updating your PATH, and validating your Laravel app. It also covers Composer, rollback, and troubleshooting.

---

## 1. Download & Extract PHP 8.3

- Go to: https://windows.php.net/download
- Download: **PHP 8.3.x (x64) Thread Safe** zip
- Extract to: `C:\php83`

## 2. Configure `php.ini`

- Copy `php.ini-development` to `php.ini`
- Edit `php.ini`:
  - Set:
    ```
    extension_dir = "ext"
    date.timezone = "Africa/Lagos"
    memory_limit = 512M
    max_execution_time = 120
    ```
  - Enable extensions (uncomment):
    ```
    extension=pdo_mysql
    extension=mysqli
    extension=mbstring
    extension=openssl
    extension=intl
    extension=fileinfo
    extension=gd
    extension=curl
    extension=sodium
    extension=zip
    extension=bcmath
    ```
  - If you see warnings (e.g., `bcmath`), ensure `php_bcmath.dll` exists in `ext/`. If not, re-extract or download a full PHP zip.

## 3. Add PHP 8.3 to PATH

- Windows Search → "Environment Variables"
- Edit **User** PATH, add `C:\php83` **above** any `C:\xampp\php`
- Open a new PowerShell:
  ```
  php -v
  ```
  Should show 8.3.x

## 4. Validate Extensions

- Run:
  ```
  php -m
  ```
  Ensure at least: `pdo_mysql`, `mbstring`, `openssl`, `intl`, `fileinfo`, `gd`, `curl`, `sodium`, `zip`, `bcmath`
- If any are missing, check `ext/` folder and `php.ini`.

## 5. Composer & Laravel

- In `bonny_app`:
  ```
  php composer.phar diagnose
  php composer.phar check-platform-reqs
  php composer.phar install --no-interaction
  php artisan about
  php artisan key:generate (if needed)
  php artisan migrate:status
  ```

## 6. Rollback

- To revert, move `C:\php83` below `C:\xampp\php` in PATH, open new shell.
- No project files are changed by this upgrade.

## 7. Troubleshooting

- **Missing DLL**: Ensure all `.dll` files are present in `ext/`.
- **Extension errors**: Download a fresh PHP zip, re-extract, or copy missing DLLs from another PHP 8.3 build.
- **Apache**: Only update Apache config to use PHP 8.3 after CLI is stable and Laravel works.

---

**After upgrade, let your assistant run:**

```
php artisan about
php artisan migrate:status
php artisan test
```

for a full health check.
