<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Order;
use App\Models\Stay;
use Illuminate\Support\Facades\DB;

class BackfillOrderDeliveryFields extends Command
{
    protected $signature = 'orders:backfill-delivery {--dry-run : Show what would change without updating}';
    protected $description = 'Backfill new delivery_mode/state/guest fields for legacy orders';

    public function handle(): int
    {
        $dry = $this->option('dry-run');
        $updated = 0; $total = 0; $modes = ['room'=>0,'external'=>0]; $states = [];
        $this->info(($dry ? '[DRY RUN] ' : '').'Scanning orders...');
        Order::chunkById(500, function($chunk) use (&$updated,&$total,&$modes,&$states,$dry){
            foreach ($chunk as $order) {
                $total++;
                $dirty = false;
                if (!$order->delivery_mode) { $order->delivery_mode = 'external'; $dirty = true; $modes['external']++; }
                if (!$order->state) {
                    $order->state = \App\Models\Order::legacyStatusToState($order->status);
                    $dirty = true; $states[$order->state] = ($states[$order->state] ?? 0)+1;
                }
                if ($order->ordered_by_guest === null) {
                    // Try to attach stay by temporal overlap if stay_id empty
                    if (!$order->stay_id) {
                        $stay = Stay::where('user_id',$order->user_id)->orderByDesc('check_in_at')->first();
                        if ($stay) { $order->stay_id = $stay->id; $order->guest_room_number = $stay->room_number; }
                    }
                    $order->ordered_by_guest = $order->stay_id ? 1 : 0; $dirty = true;
                }
                if ($dirty) {
                    if (!$dry) $order->save();
                    $updated++;
                }
            }
        });
        $this->info("Processed: $total, Updated: $updated");
        if ($states) $this->line('States assigned: '.json_encode($states));
        if ($modes) $this->line('Modes (new only): '.json_encode($modes));
        return self::SUCCESS;
    }
}
