<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Hash;

class CreateSuperAdminUser extends Command
{
    protected $signature = 'user:create-super-admin';
    protected $description = 'Create the Super Admin user with predefined credentials';

    public function handle()
    {
        // Create Super Admin role if it doesn't exist
        $superAdminRole = Role::firstOrCreate(['name' => 'Super Admin']);
        $this->info('Super Admin role created/verified.');
        
        // Check if user already exists
        $existingUser = User::where('email', 'superadmin@bonnydelight.ng')->first();
        if ($existingUser) {
            $this->info('Super Admin user already exists.');
            if (!$existingUser->hasRole('Super Admin')) {
                $existingUser->assignRole('Super Admin');
                $this->info('Super Admin role assigned to existing user.');
            }
            return 0;
        }
        
        // Create the Super Admin user
        $user = User::create([
            'name' => 'Super Admin',
            'email' => 'superadmin@bonnydelight.ng',
            'phone' => '+234-800-SUPER-1',
            'password' => Hash::make('ChangeMe123!'),
            'email_verified_at' => now(),
            'is_active' => true
        ]);
        
        // Assign Super Admin role
        $user->assignRole('Super Admin');
        
        $this->info('Super Admin user created successfully!');
        $this->info('Email: superadmin@bonnydelight.ng');
        $this->info('Password: ChangeMe123!');
        $this->info('You can now access the Super Admin panel at /super-admin');
        
        return 0;
    }
}