<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Support\ImageVariantGenerator;

class GenerateImageVariants extends Command
{
    protected $signature = 'images:variants {paths* : Relative paths under public/} {--widths=320,640,1024,1536} {--formats=webp,avif}';
    protected $description = 'Generate image variants (webp/avif) for supplied public images';

    public function handle(): int
    {
        $paths = (array) $this->argument('paths');
        $widths = array_map('intval', array_filter(explode(',', (string) $this->option('widths'))));
        $formats = array_filter(array_map('trim', explode(',', (string) $this->option('formats'))));
        if (empty($formats)) $formats = ['webp'];
        $totalGen = 0; $totalSkip = 0;
        foreach ($paths as $p) {
            $res = ImageVariantGenerator::generateVariants($p, $widths, $formats);
            $this->line(sprintf('%s -> generated:%d skipped:%d', $p, $res['generated'], $res['skipped']));
            $totalGen += $res['generated'];
            $totalSkip += $res['skipped'];
        }
        $this->info(sprintf('Done. generated:%d skipped:%d', $totalGen, $totalSkip));
        return self::SUCCESS;
    }
}
