<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class NormalizeOrderDeliveryAddresses extends Command
{
    protected $signature = 'orders:normalize-delivery {--dry-run : Show changes without writing} {--chunk=500 : Chunk size for processing}';
    protected $description = 'Ensure room delivery orders have canonical delivery_address (Room <number>)';

    public function handle(): int
    {
        $dry = (bool)$this->option('dry-run');
        $chunk = (int)$this->option('chunk');
        $updated = 0; $skipped = 0; $total = 0;

        DB::table('orders')
            ->where('delivery_mode','room')
            ->orderBy('id')
            ->chunkById($chunk, function($orders) use (&$updated,&$skipped,&$total,$dry){
                foreach ($orders as $o) {
                    $total++;
                    if ($o->delivery_address) { $skipped++; continue; }
                    $room = $o->guest_room_number ?? $o->room_number;
                    if (!$room) { $skipped++; continue; }
                    $canonical = 'Room '.$room;
                    if ($dry) {
                        $this->line("Would set order #{$o->id} -> {$canonical}");
                    } else {
                        DB::table('orders')->where('id',$o->id)->update(['delivery_address' => $canonical]);
                        $updated++;
                    }
                }
            });

        $this->info("Processed: {$total}; Updated: {$updated}; Skipped: {$skipped}");
        if ($dry) $this->warn('Dry run – no changes written.');
        return self::SUCCESS;
    }
}
