<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use Spatie\Permission\Models\Role;

class SetupSuperAdmin extends Command
{
    protected $signature = 'super-admin:setup {email?}';
    protected $description = 'Create Super Admin role and assign it to a user';

    public function handle()
    {
        // Create Super Admin role if it doesn't exist
        $superAdminRole = Role::firstOrCreate(['name' => 'Super Admin']);
        $this->info('Super Admin role created/verified.');
        
        // Create Admin role if it doesn't exist (for completeness)
        $adminRole = Role::firstOrCreate(['name' => 'Admin']);
        $this->info('Admin role created/verified.');
        
        // Get user email
        $email = $this->argument('email');
        if (!$email) {
            $email = $this->ask('Enter the email address of the user to make Super Admin');
        }
        
        // Find user
        $user = User::where('email', $email)->first();
        if (!$user) {
            $this->error("User with email '{$email}' not found.");
            $this->info('Available users:');
            User::all()->each(function($user) {
                $this->line("  - {$user->email} ({$user->name})");
            });
            return 1;
        }
        
        // Assign Super Admin role
        if (!$user->hasRole('Super Admin')) {
            $user->assignRole('Super Admin');
            $this->info("Super Admin role assigned to {$user->name} ({$user->email})");
        } else {
            $this->info("User {$user->name} already has Super Admin role.");
        }
        
        $this->info('Setup complete! You can now access the Super Admin panel at /super-admin');
        
        return 0;
    }
}