<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Storage;

class SyncDishOriginals extends Command
{
    protected $signature = 'images:sync-originals {--clean : Remove orphaned copied originals}';
    protected $description = 'Copy dish original images from storage/app/public/dishes to public/assets/dishes/originals for direct serving.';

    public function handle(): int
    {
        $disk = Storage::disk('public');
        $files = collect($disk->files('dishes'))->filter(fn($f)=>preg_match('/\.(jpe?g|png)$/i',$f));
        $destDir = public_path('assets/dishes/originals');
        if (!is_dir($destDir)) mkdir($destDir,0775,true);
        $copied = 0;
        foreach ($files as $rel) {
            $base = basename($rel);
            $target = $destDir.DIRECTORY_SEPARATOR.$base;
            $srcPath = $disk->path($rel);
            if (!is_file($target)) {
                @copy($srcPath,$target) && $copied++;
            }
        }
        if ($this->option('clean')) {
            $existing = collect(scandir($destDir))->filter(fn($f)=>preg_match('/\.(jpe?g|png)$/i',$f));
            foreach ($existing as $f) {
                if (!$files->contains('dishes/'.$f)) {
                    @unlink($destDir.DIRECTORY_SEPARATOR.$f);
                }
            }
        }
        $this->info("Copied $copied originals to assets/dishes/originals");
        return self::SUCCESS;
    }
}
