<?php

namespace App\Enums;

/**
 * Backed enum representing internal order lifecycle states.
 */
enum OrderState: string
{
    case AWAITING_PAYMENT = 'awaiting_payment';
    case AWAITING_REVIEW  = 'awaiting_review';
    case AWAITING_KITCHEN = 'awaiting_kitchen';
    case PREPARING        = 'preparing';
    case READY            = 'ready';
    case DELIVERING       = 'delivering';
    case COMPLETED        = 'completed';
    case CANCELLED        = 'cancelled';

    /**
     * Map an enum state to a legacy display status string.
     */
    public function toDisplayStatus(): string
    {
        return match($this) {
            self::AWAITING_PAYMENT, self::AWAITING_REVIEW, self::AWAITING_KITCHEN => 'Received',
            self::PREPARING => 'In Kitchen',
            self::READY => 'Ready',
            self::DELIVERING => 'Out for Delivery',
            self::COMPLETED => 'Delivered',
            self::CANCELLED => 'Cancelled',
        };
    }
}
