<?php

if (!function_exists('format_currency')) {
    /**
     * Format currency values consistently across the application
     *
     * @param float|int $amount
     * @param bool $showSymbol
     * @param int|null $decimals
     * @return string
     */
    function format_currency($amount, $showSymbol = true, $decimals = null)
    {
        $currency = config('app.currency');
        $decimals = $decimals ?? $currency['decimal_places'];
        
        $formatted = number_format((float)$amount, $decimals);
        
        return $showSymbol ? $currency['symbol'] . $formatted : $formatted;
    }
}

if (!function_exists('currency_symbol')) {
    /**
     * Get the currency symbol
     *
     * @return string
     */
    function currency_symbol()
    {
        return config('app.currency.symbol', '₦');
    }
}

if (!function_exists('currency_code')) {
    /**
     * Get the currency code
     *
     * @return string
     */
    function currency_code()
    {
        return config('app.currency.code', 'NGN');
    }
}