<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\CustomerAddress;
use App\Models\User;
use Illuminate\Http\Request;

class CustomerAddressAdminController extends Controller
{
    public function index(Request $request)
    {
        $q = CustomerAddress::query()->with('user');
        if ($search = $request->string('q')->trim()) {
            $q->where(function($w) use ($search){
                $w->where('raw_address','like',"%$search%")
                  ->orWhere('formatted_address','like',"%$search%")
                  ->orWhereHas('user', fn($u)=>$u->where('name','like',"%$search%"));
            });
        }
        $addresses = $q->orderByDesc('last_used_at')->paginate(40)->withQueryString();
        $total = CustomerAddress::count();
        return view('admin.addresses.index', compact('addresses','total'));
    }

    public function show(CustomerAddress $address)
    {
        $address->load('orders','user');
        return view('admin.addresses.show', compact('address'));
    }
}
