<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;

class SettingController extends Controller
{
    public function index()
    {
        $settings = Setting::query()->orderBy('group')->orderBy('key')->get();
        return view('admin.settings.index', compact('settings'));
    }

    public function update(Request $request)
    {
        $data = $request->validate([
            'settings' => 'array',
        ]);

        foreach (($data['settings'] ?? []) as $key => $val) {
            $row = Setting::where('key',$key)->first();
            if (!$row) continue; // ignore unknown keys

            // normalize boolean checkboxes
            if ($row->type === 'bool') {
                $val = $request->has("settings.$key");
            }

            Setting::set($key, $val, $row->type, $row->group, $row->description, $row->autoload);
        }

        return back()->with('status','Settings updated');
    }
}
