<?php

namespace App\Http\Controllers;

use App\Models\Category;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    public function index(Request $request)
    {
        $q = trim((string) $request->get('q', ''));
        $perPage = (int) ($request->get('perPage', 15));
        if (!in_array($perPage, [10,15,25,50,100], true)) { $perPage = 15; }
        $sort = (string) $request->get('sort', 'name');
        $dir = strtolower((string) $request->get('dir', 'asc')) === 'desc' ? 'desc' : 'asc';
        $sortable = ['name' => 'name', 'updated' => 'updated_at', 'created' => 'created_at'];
        $orderBy = $sortable[$sort] ?? 'name';

        $query = Category::query();
        if ($q !== '') {
            $query->where('name', 'like', "%$q%");
        }

        $categories = $query->orderBy($orderBy, $dir)->paginate($perPage)->withQueryString();
        return view('admin.categories.index', compact('categories', 'q', 'sort', 'dir', 'perPage'));
    }

    public function create()
    {
        return view('admin.categories.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate(['name' => 'required|string|max:100']);
        Category::create($data);
        return redirect()->route('admin.categories.index')->with('status','Category created');
    }

    public function edit(Category $category)
    {
        return view('admin.categories.edit', compact('category'));
    }

    public function update(Request $request, Category $category)
    {
        $data = $request->validate(['name' => 'required|string|max:100']);
        $category->update($data);
        return redirect()->route('admin.categories.index')->with('status','Category updated');
    }

    public function destroy(Category $category)
    {
        $category->delete();
        return redirect()->route('admin.categories.index')->with('status','Category deleted');
    }
}
