<?php

namespace App\Http\Controllers;

use App\Models\ContactMessage;
use Illuminate\Http\Request;
use Illuminate\Pagination\LengthAwarePaginator;

class ContactController extends Controller
{
    // Public
    public function show()
    {
        return view('contact');
    }

    public function submit(Request $request)
    {
        $data = $request->validate([
            'name' => ['required','string','max:120'],
            'email' => ['required','email','max:160'],
            'phone' => ['nullable','string','max:40'],
            'subject' => ['nullable','string','max:160'],
            'message' => ['required','string','max:5000'],
        ]);
        try {
            $data['ip'] = $request->ip();
            $data['user_agent'] = (string) $request->userAgent();
            ContactMessage::create($data);
            return back()->with('status', 'Thanks! We\'ll get back to you shortly.');
        } catch (\Throwable $e) {
            // Graceful degrade if DB is unavailable
            return back()->with('status', 'We\'ve received your message. Our inbox may be temporarily offline; we\'ll sync it shortly.');
        }
    }

    // Admin index
    public function index()
    {
        $dbUnavailable = false;
        try {
            $messages = ContactMessage::latest()->paginate(20);
        } catch (\Throwable $e) {
            $dbUnavailable = true;
            $messages = new LengthAwarePaginator([], 0, 20, 1, [
                'path' => request()->url(),
                'query' => request()->query(),
            ]);
        }
        return view('admin.contact-messages.index', compact('messages', 'dbUnavailable'));
    }
}
