<?php

namespace App\Http\Controllers;

use App\Models\CustomerAddress;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CustomerAddressController extends Controller
{
    public function index()
    {
        $addresses = CustomerAddress::where('user_id', Auth::id())
            ->orderByDesc('is_primary')
            ->orderByDesc('last_used_at')
            ->get();
        return view('account.addresses.index', compact('addresses'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'raw_address' => 'required|string|max:500',
            'label' => 'nullable|string|max:100'
        ]);
        $normalized = preg_replace('/\s+/', ' ', trim(mb_strtolower($data['raw_address'])));
        $hash = sha1($normalized);
        $addr = CustomerAddress::firstOrNew([
            'user_id' => Auth::id(),
            'address_hash' => $hash,
        ]);
        if (! $addr->exists) {
            $addr->raw_address = $data['raw_address'];
            $addr->formatted_address = $data['raw_address'];
            $addr->times_used = 0;
            $addr->last_used_at = now();
            $addr->is_primary = ! CustomerAddress::where('user_id', Auth::id())->exists();
            $addr->save();
        }
        return redirect()->route('account.addresses.index')->with('status','Address saved');
    }

    public function setPrimary(CustomerAddress $address)
    {
        abort_unless($address->user_id === Auth::id(), 403);
        CustomerAddress::where('user_id', Auth::id())->update(['is_primary' => false]);
        $address->is_primary = true; $address->save();
        return back()->with('status','Primary address updated');
    }

    public function destroy(CustomerAddress $address)
    {
        abort_unless($address->user_id === Auth::id(), 403);
        $address->delete();
        return back()->with('status','Address removed');
    }
}
