<?php

namespace App\Http\Controllers;

use App\Models\Category;
use Illuminate\Http\Request;

class MenuController extends Controller
{
    public function index(Request $request)
    {
        $selected = $request->query('category');
        $dbUnavailable = false;
        $categories = collect();
        try {
            $query = Category::query()->with(['dishes' => function ($q) {
                $q->orderBy('name');
            }])->orderBy('name');

            if ($selected) {
                $query->where('name', $selected);
            }

            $categories = $query->get();
        } catch (\Throwable $e) {
            $dbUnavailable = true;
            // leave $categories as empty collection; view will render friendly fallback
        }

        return view('menu.index', [
            'categories' => $categories,
            'selectedCategory' => $selected,
            'dbUnavailable' => $dbUnavailable,
        ]);
    }

    public function json()
    {
        try {
            $categories = Category::with(['dishes' => function($q){ $q->orderBy('name'); }])
                ->orderBy('name')
                ->get();
            return response()->json([
                'generated_at' => now()->toIso8601String(),
                'categories' => $categories,
                'db_unavailable' => false,
            ]);
        } catch (\Throwable $e) {
            return response()->json([
                'generated_at' => now()->toIso8601String(),
                'categories' => [],
                'db_unavailable' => true,
            ], 200);
        }
    }
}
