<?php

namespace App\Http\Controllers\SuperAdmin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;

class UserManagementController extends Controller
{
    public function index(Request $request)
    {
        $query = User::with('roles');
        
        // Search functionality
        if ($search = $request->get('search')) {
            $query->where(function($q) use ($search) {
                $q->where('name', 'like', "%{$search}%")
                  ->orWhere('email', 'like', "%{$search}%");
            });
        }
        
        // Role filter
        if ($roleFilter = $request->get('role')) {
            $query->role($roleFilter);
        }
        
        $users = $query->orderBy('created_at', 'desc')->paginate(20);
        $roles = Role::all();
        
        return view('super-admin.users.index', compact('users', 'roles'));
    }
    
    public function edit(User $user)
    {
        $user->load('roles');
        $roles = Role::all();
        
        return view('super-admin.users.edit', compact('user', 'roles'));
    }
    
    public function update(Request $request, User $user)
    {
        // Restrict to role management only
        $request->validate([
            'roles' => 'array',
            'roles.*' => 'exists:roles,name'
        ]);
        
        // Sync roles - this is the only allowed modification
        if ($request->has('roles')) {
            $user->syncRoles($request->roles);
        } else {
            $user->syncRoles([]);
        }
        
        return redirect()->route('super-admin.users.index')
            ->with('success', 'User roles updated successfully.');
    }
}