<?php

namespace App\Http\Middleware;

use App\Support\Features\FeatureGate;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Illuminate\Support\Facades\Log;

class EnsureFeature
{
    public function __construct(protected FeatureGate $gate)
    {
    }

    public function handle(Request $request, Closure $next, string $feature)
    {
        $user = $request->user();
        // Global emergency override: enable everything if true
        if (config('app.env') !== 'production' && env('FEATURES_FORCE_ALL', false)) {
            return $next($request);
        }

        $allowed = $this->gate->enabled($feature, $user);
        if (!$allowed) {
            Log::info('[feature-block] feature='.$feature.' user='.(optional($user)->id ?? 'guest').' path='.$request->path());
            // Prefer a friendly 403 with dedicated view
            if (view()->exists('errors.feature-disabled')) {
                return response()->view('errors.feature-disabled', [], 403);
            }
            throw new NotFoundHttpException();
        }
        return $next($request);
    }
}
