<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class SecurityHeaders
{
    public function handle(Request $request, Closure $next)
    {
    // Generate a per-request CSP nonce (16 bytes ~ 128 bits)
    $nonce = base64_encode(random_bytes(16));
    // Share with all views
    app('view')->share('cspNonce', $nonce);

    $response = $next($request);

        // Only add on normal responses (skip binary streams if needed)
        if (method_exists($response, 'headers')) {
            $response->headers->set('X-Frame-Options', 'SAMEORIGIN');
            $response->headers->set('X-Content-Type-Options', 'nosniff');
            $response->headers->set('X-XSS-Protection', '0'); // modern browsers ignore; CSP handles this
            $response->headers->set('Referrer-Policy', 'strict-origin-when-cross-origin');
            $response->headers->set('Permissions-Policy', 'geolocation=(), microphone=(), camera=()');
            $response->headers->set('Cross-Origin-Opener-Policy', 'same-origin');
            $response->headers->set('Cross-Origin-Resource-Policy', 'same-origin');
            $response->headers->set('Cross-Origin-Embedder-Policy', 'unsafe-none');
            // Basic CSP (adjust as assets evolve). Allow self + inline styles (Tailwind dev) and data: images.
            // Build script-src with required self + nonce. Optionally allow 'unsafe-eval' ONLY in local dev if explicitly enabled
            // to silence DevTools advisory warnings while keeping production hardened.
            $scriptParts = ["'self'", "'nonce-$nonce'"];
            if (app()->environment('local') && env('CSP_ALLOW_UNSAFE_EVAL_LOCAL', false)) {
                $scriptParts[] = "'unsafe-eval'"; // Dev-only convenience; DO NOT enable in production.
            }
            $scriptSrc = implode(' ', $scriptParts);
            $csp = "default-src 'self'; script-src $scriptSrc; style-src 'self' 'unsafe-inline'; img-src 'self' data:; font-src 'self' data:; connect-src 'self'; object-src 'none'; base-uri 'self'; frame-ancestors 'self'; form-action 'self'";
            $response->headers->set('Content-Security-Policy', $csp);
            // HSTS only if using HTTPS (prevent misconfiguration in plain HTTP local dev)
            if ($request->isSecure()) {
                $response->headers->set('Strict-Transport-Security', 'max-age=31536000; includeSubDomains; preload');
            }
        }

        return $response;
    }
}
