<?php

namespace App\Http\Middleware;

use App\Models\Order;
use App\Models\Setting;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class ThrottleOrdersByCapacity
{
    public function handle(Request $request, Closure $next): Response
    {
        $maxOpen = (int) Setting::get('capacity.max_open_orders', 50);
        if (Order::openOrdersCount() >= $maxOpen) {
            return redirect()->back()->withErrors(['checkout' => 'We are currently at capacity. Please try again shortly.']);
        }
        return $next($request);
    }
}
