<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CustomerAddress extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'user_id','label','raw_address','formatted_address','address_hash','latitude','longitude','times_used','last_used_at','is_primary'
    ];

    protected $casts = [
        'last_used_at' => 'datetime',
        'is_primary' => 'boolean',
    ];

    public function user(){ return $this->belongsTo(User::class); }
    public function orders(){ return $this->hasMany(Order::class, 'customer_address_id'); }
}
