<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Stay extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id','room_number','check_in_at','check_out_at','status','pms_ref'
    ];

    protected $casts = [
        'check_in_at' => 'datetime',
        'check_out_at' => 'datetime',
    ];

    public function user(){ return $this->belongsTo(User::class); }

    public function scopeActive($q){ return $q->where('status','active'); }

    /**
     * Get all active room numbers (for validation in large hotels)
     * @return array
     */
    public static function activeRoomNumbers(): array
    {
        return static::active()
            ->whereNotNull('room_number')
            ->pluck('room_number')
            ->map(fn($r) => strtolower(trim($r)))
            ->unique()
            ->values()
            ->toArray();
    }
}
