<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
    'name',
    'first_name',
    'last_name',
    'gender',
    'email',
    'phone',
    'password',
    'is_guest',
    'room_number',
    'role',
    'phone_verified',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
            'phone_verified' => 'bool',
        ];
    }
    
    /**
     * A sanitized display name that is always a string.
     */
    public function getDisplayNameAttribute(): string
    {
        $name = $this->attributes['name'] ?? $this->name ?? '';
        if (is_array($name)) {
            // common shapes: ['name'=>...] or first non-empty string in the array
            $name = $name['name'] ?? (function(array $arr): string {
                foreach ($arr as $v) { if (is_string($v) && $v !== '') return $v; }
                return '';
            })($name);
        } elseif (!is_string($name)) {
            $name = '';
        }

        if ($name === '') {
            // Fallback to email local part or a generic label
            $email = $this->email;
            if (is_string($email) && $email !== '') {
                $local = explode('@', $email)[0] ?? $email;
                return $local !== '' ? $local : 'Account';
            }
            return 'Account';
        }
        return $name;
    }

    /**
     * Get the orders for the user.
     */
    public function orders(): HasMany
    {
        return $this->hasMany(Order::class);
    }
}
