<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\Facades\View;
use App\Support\Features\FeatureGate;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->singleton(FeatureGate::class, fn() => new FeatureGate());
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Blade::component('admin-layout', \App\View\Components\AdminLayout::class);
        // Provide a safe default CSP nonce for all views; middleware may override per-request
        View::share('cspNonce', '');

        Blade::if('feature', function(string $feature) {
            /** @var FeatureGate $gate */
            $gate = app(FeatureGate::class);
            return $gate->enabled($feature, auth()->user());
        });
    }
}
