<?php

namespace App\Providers;

use App\Services\Geo\{GeoServiceInterface, GoogleGeoService, CachedGeoService};
use Illuminate\Support\ServiceProvider;

class DeliveryServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        $this->app->singleton(GeoServiceInterface::class, function ($app) {
            $config = $app['config']->get('delivery');
            $provider = $config['geocode_provider'] ?? 'google';
            $ttl = (int) ($config['geocode_cache_ttl'] ?? 86400);
            $apiKey = $config['google_api_key'] ?? null;
            $base = match ($provider) {
                'google' => new GoogleGeoService($apiKey),
                default => new GoogleGeoService($apiKey),
            };
            return new CachedGeoService($base, $ttl);
        });
    }
}
