<?php

namespace App\Services\Delivery;

use App\Models\Stay;
use App\Models\User;

class DeliveryContext
{
    public function __construct(
        public readonly ?User $user,
        public readonly ?Stay $activeStay,
        public readonly string $deliveryMode, // room|external
        public readonly ?string $rawAddress,
        public readonly float $radiusKm,
        public readonly float $hotelLat,
        public readonly float $hotelLng,
        public readonly bool $requireVerification
    ) {}
}
