<?php

namespace App\Services\Delivery;

class VerificationDecision
{
    public function __construct(
        public readonly string $status, // ACCEPT|REJECT|FLAG
        public readonly string $reason,
        public readonly ?float $distanceKm = null,
        public readonly ?float $lat = null,
        public readonly ?float $lng = null,
        public readonly array $meta = []
    ) {}

    public static function accept(string $reason, ?float $distance = null, ?float $lat=null, ?float $lng=null, array $meta=[]): self
    { return new self('ACCEPT',$reason,$distance,$lat,$lng,$meta); }
    public static function reject(string $reason, ?float $distance = null, array $meta=[]): self
    { return new self('REJECT',$reason,$distance,null,null,$meta); }
    public static function flag(string $reason, ?float $distance = null, array $meta=[]): self
    { return new self('FLAG',$reason,$distance,null,null,$meta); }
}
