<?php

namespace App\Services\Geo;

use Illuminate\Support\Facades\Cache;

class CachedGeoService implements GeoServiceInterface
{
    public function __construct(
        private GeoServiceInterface $inner,
        private int $ttlSeconds = 86400
    ) {}

    public function geocode(string $raw): ?GeoResult
    {
        $key = 'geo:'.sha1(strtolower(trim($raw)));
        return Cache::remember($key, $this->ttlSeconds, fn()=> $this->inner->geocode($raw));
    }
}
