<?php

namespace App\Support\Features;

use Illuminate\Contracts\Auth\Authenticatable;

class FeatureGate
{
    protected array $config;

    public function __construct()
    {
        $this->config = config('features', []);
    }

    public function enabled(string $feature, ?Authenticatable $user = null): bool
    {
        $features = $this->config['features'] ?? [];
        if (!array_key_exists($feature, $features)) {
            return false; // unknown feature disabled by default
        }
        $def = $features[$feature];
        if (is_bool($def)) {
            return $def; // simple on/off
        }
        if (isset($def['enabled']) && $def['enabled'] === false) {
            return false;
        }
        // Role-based? (array of roles or array with 'roles' key)
        $roles = $def['roles'] ?? ($def['allowed_roles'] ?? ($def['value'] ?? []));
        if ($user === null) {
            return false; // requires auth context
        }
        // If no roles specified treat as globally enabled
        if (empty($roles)) {
            return true;
        }
        // User model should have roles relationship via spatie/permission
        try {
            foreach ($roles as $role) {
                if ($user->hasRole($role)) {
                    return true;
                }
            }
        } catch (\Throwable $e) {
            // Fallback: if user has no role system yet, block to be safe
            return false;
        }
        return false;
    }
}
