<?php

if (!function_exists('safe_trans')) {
    /**
     * Safely translate a string, always returning a string type.
     * Prevents htmlspecialchars errors when translation returns arrays.
     *
     * @param string $key
     * @param array $replace
     * @param string|null $locale
     * @return string
     */
    function safe_trans(string $key, array $replace = [], ?string $locale = null): string
    {
        $translation = __($key, $replace, $locale);
        
        // If translation returns an array (misconfigured), extract first string value or return key
        if (is_array($translation)) {
            foreach ($translation as $value) {
                if (is_string($value)) {
                    return $value;
                }
            }
            return $key;
        }
        
        // Ensure we always return a string
        return is_string($translation) ? $translation : (string) $translation;
    }
}

if (!function_exists('safe_config')) {
    /**
     * Safely get a config value as string.
     * Prevents htmlspecialchars errors when config returns arrays.
     *
     * @param string $key
     * @param mixed $default
     * @return string
     */
    function safe_config(string $key, $default = ''): string
    {
        $value = config($key, $default);
        
        if (is_array($value)) {
            return $default && is_string($default) ? $default : '';
        }
        
        return is_string($value) ? $value : (string) $value;
    }
}
