<?php

namespace App\View\Components;

use App\Support\ImageManifest;
use Illuminate\View\Component;

class ResponsiveImage extends Component
{
    public string $type; // dish|slider
    public string $base;
    public string $alt;
    public ?string $class;
    public ?string $sizes;
    public string $loading;
    public ?string $fetchpriority;
    public ?string $fallback; // optional manual fallback src

    public ?array $entry = null;

    public function __construct(
        string $type,
        string $base,
        string $alt = '',
        ?string $class = null,
        ?string $sizes = null,
        string $loading = 'lazy',
        ?string $fetchpriority = null,
        ?string $fallback = null,
    ) {
        $this->type = $type;
        $this->base = $base;
        $this->alt = $alt !== '' ? $alt : ucfirst(str_replace(['-','_'],' ', $base));
        $this->class = $class;
        $this->sizes = $sizes;
        $this->loading = $loading;
        $this->fetchpriority = $fetchpriority;
        $this->fallback = $fallback;
        $this->entry = ImageManifest::find($type, $base);
    }

    public function render()
    {
        return view('components.responsive-image');
    }
}
