<?php
/*
 * Database configuration file
 *
 * This file establishes a connection to the MySQL database using
 * PDO. Edit the $dbHost, $dbUser, $dbPass and $dbName variables to
 * suit your environment. On failure it will throw a PDOException.
 */

$dbHost = getenv('BONNY_DB_HOST') ?: 'localhost';
$dbUser = getenv('BONNY_DB_USER') ?: 'root';
$dbPass = getenv('BONNY_DB_PASS') ?: 'vick247$';
$dbName = getenv('BONNY_DB_NAME') ?: 'bonny_delight';
$charset = 'utf8mb4';

$dsn = "mysql:host=$dbHost;dbname=$dbName;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
    $pdo = new PDO($dsn, $dbUser, $dbPass, $options);
} catch (Exception $e) {
    die('Database connection failed: ' . $e->getMessage());
}

// --- Base path & URL helpers -------------------------------------------------
// Detect the base path so absolute links work when the site is served on a port
// or subfolder (e.g., http://localhost:9090/bonny_delight/)
if (!defined('BASE_PATH')) {
    $scriptName = $_SERVER['SCRIPT_NAME'] ?? '/';
    $detected   = rtrim(str_replace('\\', '/', dirname($scriptName)), '/');
    if ($detected === '') { $detected = '/'; }
    $envBase    = getenv('BONNY_BASE_PATH');
    define('BASE_PATH', $envBase !== false && $envBase !== '' ? rtrim($envBase, '/') : $detected);
}

if (!function_exists('url')) {
    function url(string $path = ''): string {
        $path = ltrim($path, '/');
        if (BASE_PATH === '/' || BASE_PATH === '') {
            return '/' . $path;
        }
        return BASE_PATH . '/' . $path;
    }
}