<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? htmlspecialchars($page_title) . ' – Bonny Delight' : 'Bonny Delight'; ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9" crossorigin="anonymous">
  <link rel="stylesheet" href="<?php echo url('assets/css/style.css'); ?>">
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container">
    <a class="navbar-brand" href="<?php echo url('index.php'); ?>">
      <img src="<?php echo url('assets/logo.png'); ?>" alt="Bonny Delight logo" width="40" height="40" class="d-inline-block align-text-top">
      Bonny Delight
    </a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navmenu" aria-controls="navmenu" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navmenu">
      <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
  <li class="nav-item"><a class="nav-link" href="<?php echo url('index.php'); ?>">Home</a></li>
  <li class="nav-item"><a class="nav-link" href="<?php echo url('menu.php'); ?>">Menu</a></li>
  <li class="nav-item"><a class="nav-link" href="<?php echo url('cart.php'); ?>">Cart<?php if (!empty($_SESSION['cart'])) echo ' (' . array_sum(array_column($_SESSION['cart'], 'quantity')) . ')'; ?></a></li>
        <?php if (isset($_SESSION['user_id'])): ?>
          <li class="nav-item"><a class="nav-link" href="<?php echo url('order_history.php'); ?>">My Orders</a></li>
          <li class="nav-item"><a class="nav-link" href="<?php echo url('logout.php'); ?>">Logout</a></li>
        <?php else: ?>
          <li class="nav-item"><a class="nav-link" href="<?php echo url('login.php'); ?>">Login</a></li>
          <li class="nav-item"><a class="nav-link" href="<?php echo url('register.php'); ?>">Sign Up</a></li>
        <?php endif; ?>
      </ul>
    </div>
  </div>
</nav>
<div class="container mt-4">