<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        // Define the web middleware group (rough analogue of old Kernel web stack)
        $middleware->web(prepend: [
            // Cookie & session handling
            Illuminate\Cookie\Middleware\EncryptCookies::class,
            Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse::class,
            Illuminate\Session\Middleware\StartSession::class,
            // Share errors from session to views
            Illuminate\View\Middleware\ShareErrorsFromSession::class,
            // CSRF (keep early for forms; safe in tests – they auto-bypass via helpers)
            Illuminate\Foundation\Http\Middleware\VerifyCsrfToken::class,
            // Route model bindings
            Illuminate\Routing\Middleware\SubstituteBindings::class,
        ]);

        // Define the api middleware group (lightweight stateless)
        $middleware->api(prepend: [
            'throttle:api',
            Illuminate\Routing\Middleware\SubstituteBindings::class,
        ]);

        // Register middleware aliases (route-level)
        $middleware->alias([
            'role' => Spatie\Permission\Middleware\RoleMiddleware::class,
            'permission' => Spatie\Permission\Middleware\PermissionMiddleware::class,
            'role_or_permission' => Spatie\Permission\Middleware\RoleOrPermissionMiddleware::class,
            'orders.capacity' => App\Http\Middleware\ThrottleOrdersByCapacity::class,
            'feature' => App\Http\Middleware\EnsureFeature::class,
            'super.admin' => App\Http\Middleware\SuperAdminMiddleware::class,
        ]);

        // Lightweight global security headers (append so it runs after response is generated)
        $middleware->append(App\Http\Middleware\SecurityHeaders::class);
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        //
    })->create();
