<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Feature Flags / Role Mapping
    |--------------------------------------------------------------------------
    | Structure:
    |  'feature_key' => true | false | [ 'enabled' => bool, 'roles' => ['Role1','Role2'] ]
    |
    | Unknown features return false (secure by default). A simple boolean means
    | global enable/disable (no role restriction). An array allows scoping by role.
    |
    | Emergency Override:
    |  Set env FEATURES_FORCE_ALL=true (non-production only) to bypass checks.
    |  This is checked in EnsureFeature middleware.
    |
    | Future Extensions:
    |  - Database overrides (merge here)
    |  - Percentage rollouts / gradual exposure
    |  - Dependency graph (e.g., checkout depends_on: ['orders'])
    */
    'features' => [
        'checkout' => [ 'enabled' => true, 'roles' => ['Customer','Super Admin','Manager','Cashier'] ],
        'orders'   => [ 'enabled' => true, 'roles' => ['Customer','Super Admin','Manager','Cashier'] ],
        'addresses'=> [ 'enabled' => true, 'roles' => ['Customer','Super Admin','Manager'] ],
    ],
];
