<?php

return [
    // Base disk for originals (Laravel "public" disk -> storage/app/public)
    'disk' => env('IMAGES_DISK', 'public'),

    // Subdirectories (relative to disk root)
    'paths' => [
        'dishes' => 'dishes',
        'sliders' => 'sliders',
    ],

    // Seed source (where raw seed images live inside public for first-time copy)
    'seed_source' => 'assets/images',

    // Variant resize widths (pixels)
    'variants' => [
        'dishes' => [200,400,600,800,1200],
        'sliders' => [640,1024,1536,1920],
    ],
    // Maximum original width we keep (downscale originals bigger than this to save space)
    'max_original_width' => 2400,
];
