# Customer Dashboard — Implementation Plan

This plan organizes the proposed UI/UX and functional improvements for the Customer Dashboard into actionable tasks with checklists, acceptance criteria, and suggested file locations. We will progress in small, safe phases. Tick items as you complete them.

---

## 0) Goals and guardrails

- [ ] Delight customers with a modern, fast, and informative dashboard
- [ ] Keep it accessible (keyboard, screen readers, color contrast)
- [ ] Maintain graceful degradation (DB offline: friendly banners, empty states)
- [ ] Keep components modular and lazy-load heavy bits
- [ ] Avoid breaking existing routes; ship in small increments

---

## 1) Header + topbar

Purpose: Replace the bare "Home" label with a premium header that carries quick actions and an avatar menu.

- [ ] Header layout: frosted bar (bg-white/70 dark:bg-slate-900/60 backdrop-blur ring-white/30)
- [ ] Title + optional breadcrumb (only beyond root)
- [ ] Quick actions (right): Start Order, Reorder, Track
- [ ] Avatar dropdown: Profile, Addresses, Orders, Logout
- [ ] System status chip (e.g., Kitchen: Normal • 25–35 min)

Acceptance:
- Visible consistent header on dashboard
- Buttons keyboard-focusable with discernible text

Files (suggested):
- resources/views/components/customer/header.blade.php
- resources/views/dashboard/index.blade.php (or existing `resources/views/dashboard.blade.php`)

---

## 2) KPI tiles row

- [ ] Define data model for tiles: label, value, icon, href
- [ ] Tiles: Active Order (# + ETA), Total Orders, Avg Delivery Time, Rewards/Points, Addresses, Favorites
- [ ] Blade component `x-customer.kpi-tile` with small icon chip and value
- [ ] Lightweight `/api/me/kpis` endpoint (JSON, cached for 30s)

Acceptance:
- Loading state with skeletons
- Tiles render in < 150ms after JSON ready on local

Files:
- app/Http/Controllers/Api/MeKpiController.php
- routes/web.php (or routes/api.php if preferred)
- resources/views/components/customer/kpi-tile.blade.php

---

## 3) Active order timeline

- [ ] Stepper UI: Received → In Kitchen → Out for Delivery → Delivered
- [ ] ETA countdown + timestamps per step
- [ ] Actions: Contact Support, Share Live Status
- [ ] Polling every 20–30s (pause on hidden tab)

Acceptance:
- Announces status changes via aria-live="polite"
- Backoff if DB is unavailable, shows banner

Files:
- resources/views/components/customer/active-order.blade.php
- app/Http/Controllers/CustomerOrderController.php (JSON endpoint like `/orders/{order}/status.json`)

---

## 4) Quick actions grid

- [ ] 2×3 grid: Order Now, Reorder Previous, Track Order, Manage Addresses, View Receipts, Support
- [ ] Micro-interactions on hover/focus

Acceptance:
- Works on mobile (stacked) and desktop (grid)

Files:
- resources/views/components/customer/quick-actions.blade.php

---

## 5) Orders list (tabs + filters)

- [ ] Tabs: All | Active | Completed | Cancelled
- [ ] Filters: search by #/name, date range (last 30 days), pagination
- [ ] Compact card/table hybrid with status pill + actions: View / Reorder / Receipt

Acceptance:
- Keyboard and screen-reader friendly tabs
- Empty-state and skeletons

Files:
- resources/views/components/customer/orders-list.blade.php
- app/Http/Controllers/CustomerOrderController.php (extend for filters)

---

## 6) Favorites & recommendations

- [ ] Heart toggle on dishes
- [ ] Simple recommendation: “Because you liked {X}” (top 2 categories)
- [ ] Grid with Add to cart / Reorder buttons

Acceptance:
- Instant favorite toggle (optimistic UI, rollback on error)

Files:
- resources/views/components/customer/favorites.blade.php
- routes/web.php: /favorites endpoints

---

## 7) Addresses mini-panel

- [ ] Show primary address card; Manage and Add buttons
- [ ] List of recent addresses (if applicable)

Acceptance:
- Clear primary indicator; accessible form controls

Files:
- resources/views/components/customer/addresses.blade.php

---

## 8) Promos & loyalty (optional)

- [ ] Promo cards area (dismissible)
- [ ] Loyalty widget: points, tier progress, CTA to rewards

Acceptance:
- Dismissal persisted (localStorage or DB)

Files:
- resources/views/components/customer/promos.blade.php
- resources/views/components/customer/loyalty.blade.php

---

## 9) Mobile sticky bar

- [ ] Bottom bar with Start Order • Cart • Orders • Profile
- [ ] Avoid overlap with toasts and system UI (safe-area insets)

Acceptance:
- No layout shift with toasts; clear focus order

Files:
- resources/views/components/customer/mobile-bar.blade.php

---

## 10) A11y & i18n checklist

- [ ] Roles: header/nav/main/complementary; aria-live for dynamic sections
- [ ] Ensure status pills meet AA contrast
- [ ] Keyboard traps avoided; focus rings visible
- [ ] Strings in lang files (en/messages.php) for future translation

---

## 11) Performance & skeletons

- [ ] Skeleton components for KPIs, orders, favorites
- [ ] Defer charts/scripts until visible (IntersectionObserver)
- [ ] Cache small JSON endpoints for 30–60s

---

## 12) PWA niceties

- [ ] Install App prompt card (only when applicable)
- [ ] Offline messaging (read-only mode on lists)
- [ ] "Resume order" suggestion on return

---

## Rollout plan

- [ ] Phase 1: Header + KPIs + Active Order
- [ ] Phase 2: Orders list + Quick actions
- [ ] Phase 3: Favorites + Addresses
- [ ] Phase 4 (optional): Promos + Loyalty + PWA niceties

Each phase ships behind a simple feature flag (e.g., config or .env) to enable iterative release.

---

## Notes

- Reuse existing resilience patterns (db_unavailable banners)
- Keep components small; prefer one responsibility per Blade partial
- Prefer route helpers (route(), asset()) for base-path safety
- Add tiny tests for JSON endpoints in `tests/Feature/` once endpoints are added
