<?php

namespace Database\Factories;

use App\Models\Dish;
use App\Models\Category;
use Illuminate\Database\Eloquent\Factories\Factory;

class DishFactory extends Factory
{
    protected $model = Dish::class;

    public function definition(): array
    {
        return [
            'category_id' => Category::factory(),
            'name' => $this->faker->unique()->words(3, true),
            'description' => $this->faker->sentence(8),
            'price' => $this->faker->numberBetween(500, 5000),
            'stock' => $this->faker->numberBetween(5, 50),
            'image' => null,
            'vegetarian' => $this->faker->boolean(20),
            'halal' => $this->faker->boolean(70),
            'gluten_free' => $this->faker->boolean(10),
        ];
    }
}
