<?php

namespace Database\Factories;

use App\Enums\OrderState;
use App\Models\Order;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class OrderFactory extends Factory
{
    protected $model = Order::class;

    public function definition(): array
    {
        $state = OrderState::AWAITING_KITCHEN;
        return [
            'user_id' => User::factory(),
            'subtotal' => 2000,
            'delivery_fee' => 0,
            'discount' => 0,
            'service_charge' => 0,
            'total' => 2000,
            'status' => $state->toDisplayStatus(),
            'state' => $state->value,
            'delivery_mode' => 'external',
            'delivery_address' => '123 Test Street',
            'payment_method' => 'Cash on Delivery',
        ];
    }

    protected function withState(OrderState $enum): static
    {
        return $this->state(fn() => [
            'state' => $enum->value,
            'status' => $enum->toDisplayStatus(),
        ]);
    }

    public function awaitingPayment(): static { return $this->withState(OrderState::AWAITING_PAYMENT); }
    public function awaitingReview(): static { return $this->withState(OrderState::AWAITING_REVIEW); }
    public function awaitingKitchen(): static { return $this->withState(OrderState::AWAITING_KITCHEN); }
    public function preparing(): static { return $this->withState(OrderState::PREPARING); }
    public function ready(): static { return $this->withState(OrderState::READY); }
    public function delivering(): static { return $this->withState(OrderState::DELIVERING); }
    public function completed(): static { return $this->withState(OrderState::COMPLETED); }
    public function cancelled(): static { return $this->withState(OrderState::CANCELLED); }
}
