<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasColumn('orders', 'tip')) {
            Schema::table('orders', function (Blueprint $table) {
                $table->decimal('tip', 10, 2)->default(0)->after('total');
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasColumn('orders', 'tip')) {
            Schema::table('orders', function (Blueprint $table) {
                $table->dropColumn('tip');
            });
        }
    }
};
