<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasColumn('orders', 'service_charge')) {
            Schema::table('orders', function (Blueprint $table) {
                $table->decimal('service_charge', 10, 2)->default(0)->after('discount');
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasColumn('orders', 'service_charge')) {
            Schema::table('orders', function (Blueprint $table) {
                $table->dropColumn('service_charge');
            });
        }
    }
};
